% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compare_connections}
\alias{compare_connections}
\title{Compare Cicero connections to other datasets}
\usage{
compare_connections(conns1, conns2, maxgap = 0)
}
\arguments{
\item{conns1}{A data frame of Cicero connections, like those output from
\code{assemble_connections}. The first two columns must be the coordinates
of peaks that are connected.}

\item{conns2}{A data frame of connections to be searched for overlap. The
first two columns must be coordinates of genomic sites that are connected.}

\item{maxgap}{The number of base pairs between peaks allowed to be called
overlapping. See \code{\link[IRanges]{findOverlaps-methods}} in the IRanges
package for further description.}
}
\value{
A vector of logicals of whether the Cicero pair is present in the
  alternate dataset.
}
\description{
Compare two sets of connections and return a vector of logicals for whether
connections in one are present in the other.
}
\examples{
\dontrun{
cons$in_dataset <- compare_connections(conns, alt_data)
}

}
