% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateRepeats.R
\name{annotateRepeats}
\alias{annotateRepeats}
\title{Annotate repetitive elements}
\usage{
annotateRepeats(targets, annotationHubID = "AH5122", complementary = TRUE)
}
\arguments{
\item{targets}{A list containing the target regions to analyze.
It can be generated with \code{\link{getSeqsFromGRs}}.}

\item{annotationHubID}{A string specifying the AnnotationHub id to use.
Type data(ahRepeatMasker) to see all possible options. E.g. if AH5122 is
specified, repetitive elements from Homo sapiens, genome hg19 will be
downloaded and annotated. Default value is "AH5122".}

\item{complementary}{A logical specifying whether to filter and report
only back-spliced junctions of circRNAs which flanking introns contain
complementary repeats, that is, repeats belonging to a same family but
located on opposite strands.}
}
\value{
A list.
}
\description{
The function annotateRepeats() annotates repetitive elements
located in the region flanking the back-spliced junctions of each circRNA.
Repetitive elements are provided by AnnotationHub storage which
collected repeats from RepeatMasker database. See \code{\link{AnnotationHub}}
and \url{http://www.repeatmasker.org} for more details.
An empty list is returned if none overlapping repeats  are found.
}
\examples{
# Load data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first back-spliced junctions
annotatedBSJs <- annotateBSJs(mergedBSJunctions[1, ], gtf)

# Get genome
if (requireNamespace("BSgenome.Hsapiens.UCSC.hg19", quietly = TRUE)){

genome <- BSgenome::getBSgenome("BSgenome.Hsapiens.UCSC.hg19")

# Retrieve targets
targets <- getSeqsFromGRs(
    annotatedBSJs,
    genome,
    lIntron = 200,
    lExon = 10,
    type = "ie"
    )

# Annotate repeats

# repeats <- annotateRepeats(targets, annotationHubID  = "AH5122", complementary = TRUE)

}


}
