% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignUnassigned.R
\name{assignUnassigned}
\alias{assignUnassigned}
\alias{assignUnassigned,ClusterExperiment-method}
\alias{removeUnassigned,ClusterExperiment-method}
\alias{removeUnassigned}
\title{Assign unassigned samples to nearest cluster}
\usage{
\S4method{assignUnassigned}{ClusterExperiment}(
  object,
  whichCluster = "primary",
  clusterLabel,
  makePrimary = TRUE,
  whichAssay = 1,
  reduceMethod = "none",
  ...
)

\S4method{removeUnassigned}{ClusterExperiment}(object, whichCluster = "primary")
}
\arguments{
\item{object}{A Cluster Experiment object}

\item{whichCluster}{argument that can be a single numeric or character value
indicating the \emph{single} clustering to be used. Giving values that result in more than one clustering will result in an error. See details of \code{\link{getClusterIndex}}.}

\item{clusterLabel}{if missing, the current cluster label of the cluster will
be appended with the string "_AllAssigned".}

\item{makePrimary}{whether to make the added cluster the primary cluster
(only relevant if \code{y} is a vector)}

\item{whichAssay}{which assay to use to calculate the median per cluster and
take dimensionality reduction (if requested)}

\item{reduceMethod}{character. A method (or methods) for reducing the size of
the data, either by filtering the rows (genes) or by a dimensionality
reduction method. Must either be 1) must match the name of a built-in
method, in which case if it is not already existing in the object will be
passed to \code{\link{makeFilterStats}} or \code{link{makeReducedDims}}, or
2) must match a stored filtering statistic or dimensionality reduction in
the object}

\item{...}{arguments passed to \code{\link{getReducedData}} specifying the
dimensionality reduction (if any) to be taken of the data for calculating
the medians of the clusters}
}
\value{
The function \code{assignUnassigned} returns a
  \code{ClusterExperiment} object with the unassigned samples assigned to one
  of the existing clusters.

The function \code{removeUnassigned} returns a
  \code{ClusterExperiment} object with the unassigned samples removed.
}
\description{
Assigns the unassigned samples in a cluster to the nearest
  cluster based on distance to the medians of the clusters.
}
\details{
The function \code{assignUnassigned} calculates the median values of
  each variable for each cluster, and then calculates the euclidean distance
  of each unassigned sample to the median of each cluster. Each unassigned
  sample is assigned to the cluster for which it closest to the median.

All unassigned samples in the cluster are given a clustering,
  regardless of whether they are classified as -1 or -2.

\code{removeUnclustered} removes all samples that are unclustered
  (i.e. -1 or -2 assignment) in the designated cluster of \code{object} (so
  they may be unclustered in other clusters found in
  \code{clusterMatrix(object)}).
}
\examples{
#load CE object
\dontrun{
data(rsecFluidigm)
smallCE<-rsecFluidigm[,1:50]
#assign the unassigned samples
assignUnassigned(smallCE, makePrimary=TRUE)

#note how samples are REMOVED:
removeUnassigned(smallCE)
}
}
\seealso{
\code{\link{getReducedData}}
}
