% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getReducedData.R, R/makeFilterStats.R,
%   R/makeReducedDims.R
\name{getReducedData,ClusterExperiment-method}
\alias{getReducedData,ClusterExperiment-method}
\alias{getReducedData}
\alias{defaultNDims,SingleCellExperiment-method}
\alias{defaultNDims}
\alias{defaultNDims,matrixOrHDF5-method}
\alias{reduceFunctions}
\alias{makeFilterStats}
\alias{makeFilterStats,SummarizedExperiment-method}
\alias{makeFilterStats,matrixOrHDF5-method}
\alias{makeFilterStats,ClusterExperiment-method}
\alias{listBuiltInFilterStats}
\alias{filterData,SummarizedExperiment-method}
\alias{filterData}
\alias{filterNames,SummarizedExperiment-method}
\alias{filterNames}
\alias{makeReducedDims,SingleCellExperiment-method}
\alias{makeReducedDims}
\alias{makeReducedDims,matrixOrHDF5-method}
\alias{makeReducedDims,SummarizedExperiment-method}
\alias{makeReducedDims,ClusterExperiment-method}
\alias{listBuiltInReducedDims}
\title{Return matrix from ClusterExperiment with reduced dimensions}
\usage{
\S4method{getReducedData}{ClusterExperiment}(
  object,
  reduceMethod,
  filterIgnoresUnassigned,
  nDims = defaultNDims(object, reduceMethod),
  whichCluster = "primary",
  whichAssay = 1,
  returnValue = c("object", "list"),
  reducedDimName
)

\S4method{defaultNDims}{SingleCellExperiment}(object, reduceMethod, typeToShow)

\S4method{defaultNDims}{matrixOrHDF5}(object, ...)

\S4method{makeFilterStats}{SummarizedExperiment}(
  object,
  filterStats = listBuiltInFilterStats(),
  transFun = NULL,
  isCount = FALSE,
  filterNames = NULL,
  whichAssay = 1
)

\S4method{makeFilterStats}{matrixOrHDF5}(object, ...)

\S4method{makeFilterStats}{ClusterExperiment}(
  object,
  whichClusterIgnoreUnassigned = NULL,
  filterStats = listBuiltInFilterStats(),
  ...
)

listBuiltInFilterStats()

\S4method{filterData}{SummarizedExperiment}(
  object,
  filterStats,
  cutoff,
  percentile,
  absolute = FALSE,
  keepLarge = TRUE,
  whichAssay = 1
)

\S4method{filterNames}{SummarizedExperiment}(object)

\S4method{makeReducedDims}{SingleCellExperiment}(
  object,
  reducedDims = "PCA",
  maxDims = 500,
  transFun = NULL,
  isCount = FALSE,
  whichAssay = 1
)

\S4method{makeReducedDims}{matrixOrHDF5}(object, ...)

\S4method{makeReducedDims}{SummarizedExperiment}(object, ...)

\S4method{makeReducedDims}{ClusterExperiment}(object, ...)

listBuiltInReducedDims()
}
\arguments{
\item{object}{For \code{makeReducedDims},\code{makeFilterStats},
\code{defaultNDims} either matrix-like, \code{SingleCellExperiment}, or
\code{ClusterExperiment} object. For \code{getReducedData} only a
\code{ClusterExperiment} object allowed.}

\item{reduceMethod}{character. A method (or methods) for reducing the size of
the data, either by filtering the rows (genes) or by a dimensionality
reduction method. Must either be 1) must match the name of a built-in
method, in which case if it is not already existing in the object will be
passed to \code{\link{makeFilterStats}} or \code{link{makeReducedDims}}, or
2) must match a stored filtering statistic or dimensionality reduction in
the object}

\item{filterIgnoresUnassigned}{logical. Whether filtering statistics should 
ignore the unassigned samples within the clustering. Only relevant if 
'reduceMethod' matches one of built-in filtering statistics in 
\code{\link{listBuiltInFilterStats}()}, in which case the clustering 
identified in \code{whichCluster} is passed to \code{makeFilterStats} and
the unassigned samples are excluded in calculating the statistic. See 
\code{\link{makeFilterStats}}  for more details.}

\item{nDims}{The number of dimensions to keep from \code{reduceMethod}. If
missing calls \code{\link{defaultNDims}}.}

\item{whichCluster}{argument that can be a single numeric or character value
indicating the \emph{single} clustering to be used. Giving values that result in more than one clustering will result in an error. See details of \code{\link{getClusterIndex}}.}

\item{whichAssay}{numeric or character specifying which assay to use. See
\code{\link[SummarizedExperiment]{assay}} for details.}

\item{returnValue}{The format of output. Users will generally want to keep
the default (see details)}

\item{reducedDimName}{The name given to the reducedDims slot storing result 
(if \code{returnValue="object"}). If missing, the function will create a
default name: if \code{reduceMethod} is a dimensionality reduction, then
\code{reduceMethod} will be given as the name; if a filtering statistic,
"filteredBy_" followed by \code{reduceMethod}.}

\item{typeToShow}{character (optional). If given, should be one of
"filterStats" or "reducedDims" to indicate of the values in the
reduceMethod vector, only show those corresponding to "filterStats" or
"reducedDims" options.}

\item{...}{Values passed on the the 'SingleCellExperiment' method.}

\item{filterStats}{character vector of statistics to calculate. Must be one
of the character values given by \code{listBuildInFilterStats()}.}

\item{transFun}{a transformation function to be applied to the data. If the
transformation applied to the data creates an error or NA values, then the
function will throw an error. If object is of class
\code{ClusterExperiment}, the stored transformation will be used and giving
this parameter will result in an error.}

\item{isCount}{if \code{transFun=NULL}, then \code{isCount=TRUE} will
determine the transformation as defined by \code{function(x){log2(x+1)}},
and \code{isCount=FALSE} will give a transformation function
\code{function(x){x}}. Ignored if \code{transFun=NULL}. If object is of
class \code{ClusterExperiment}, the stored transformation will be used and
giving this parameter will result in an error.}

\item{filterNames}{if given, defines the names that will be assigned to the 
filtering statistics in the \code{rowData} of the object. If missing, will be 
just the value of \code{filterStats} argument}

\item{whichClusterIgnoreUnassigned}{indicates clustering that should be used
to filter out unassigned samples from the calculations. If \code{NULL} no
filtering of samples will be done. See details for more information.}

\item{cutoff}{numeric. A value at which to filter the rows (genes) for the
test statistic}

\item{percentile}{numeric. Either a number between 0,1 indicating what
percentage of the rows (genes) to keep or an integer value indicated the
number of rows (genes) to keep}

\item{absolute}{whether to take the absolute value of the filter statistic}

\item{keepLarge}{logical whether to keep rows (genes) with large values of
the test statistic or small values of the test statistic.}

\item{reducedDims}{a vector of character values indicating the methods of
dimensionality reduction to be performed. Currently only "PCA" is
implemented.}

\item{maxDims}{Numeric vector of integer giving the number of PC dimensions
to calculate. \code{maxDims} can also take values between (0,1) to indicate
keeping the number of dimensions necessary to account for that proportion
of the variance. \code{maxDims} should be of same length as
\code{reducedDims}, indicating the number of dimensions to keep for each
method (if \code{maxDims} is of length 1, the same number of dimensions
will be used for each).}
}
\value{
If \code{returnValue="object"}, a \code{ClusterExperiment} object.

If \code{returnValue="list"} a list with elements:
\itemize{ \item{\code{objectUpdate}}{object, potentially updated if had to
calculate dimensionality reduction or filtering statistic}
\item{\code{dataMatrix}}{the reduced dimensional matrix with the samples in
columns, features in rows} }

\code{defaultNDims} returns a numeric vector giving the default
  dimensions the methods in \code{clusterExperiment} will use for reducing
  the size of the data. If \code{typeToShow} is missing, the resulting vector
  will be equal to the length of \code{reduceMethod}. Otherwise, it will be a
  vector with all the unique valid default values for the \code{typeToShow}
  (note that different dimensionality reduction methods can have different
  maximal dimensions, so the result may not be of length one in this case).

\code{makeFilterStats} returns a
  \code{\link[SummarizedExperiment]{SummarizedExperiment}} object with the
  requested filtering statistics will be added to the \code{DataFrame} in the
  \code{rowData} slot and given names corresponding to the \code{filterStats}
  values. Warning: the function will overwrite existing columns in
  \code{rowData} with the same name. Columns in the \code{rowData} slot with
  different names should not be affected.

\code{filterData} returns a SingleCellExperiment object with the rows
  (genes) removed based on filters

\code{filterNames} returns a vector of the columns of the rowData
  that are considered valid filtering statistics. Currently any numeric
  column in rowData is a valid filtering statistic.

\code{makeReducedDims} returns a \code{\link{SingleCellExperiment}}
  containing the calculated dimensionality reduction in the \code{reduceDims}
  with names corresponding to the name given in \code{reducedDims}.
}
\description{
Returns a matrix of data from a \code{ClusterExperiment} object
  based on the choices of dimensionality reduction given by the user.

Functions for calculating and manipulating either filtering
  statistics, stored in rowData, or the dimensionality reduction results,
  stored in reducedDims.
}
\details{
\code{getReducedData} determines the matrix of values that can be used for
  computation based on the user's choice of dimensionality methods. The
  methods can be either of the filtering kind or the more general
  dimensionality reduction. The function will first look at any stored
  \code{ReducedDims} or filtering statistics already present in the data, and
  if missing, will assume that \code{reduceMethod} is one of the built-in
  method provided by the package and calculate the necessary. Note that if
  \code{reduceMethod} is a filtering statistic, in addition to filtering the
  features, the function will also perform the stored transformation of the
  data.

Note that this is used internally by functions, but is mainly only
  of interest for the user if they want to have the filtered, transformed
  data available as a matrix for continual use.

If \code{returnValue="object"}, then the output is a single, updated
  \code{ClusterExperiment} object with the reduced data matrix stored as an 
  element of the list in \code{reducedDims} slot (with name given by
  \code{reducedDimName} if given). If "list", then a list with one element
  that is the object and the other that is the reduced data matrix. Either
  way, the object returned in the list will be updated to contain with the
  filtering statistics or the dimensionality reduction. The only difference
  is that if "list", the reduced dimension matrix is NOT saved in the object
  (and so only really makes a difference if the \code{reduceMethod} argument
  is a filtering method). The option "list" is mainly for internal use, where
  we do not want to continually save subseted datasets.

If \code{nDims} is missing, it will be given a default value 
  depending on the value of \code{reduceMethod}. See 
  \code{\link{defaultNDims}} for details.

If \code{filterIgnoresUnassigned} is missing, then it is set to TRUE
  \emph{unless}: \code{reduceMethod} matches a stored filtering statistic in
  \code{rowData} AND does not match a built-in filtering method provided by
  the package.

For a \code{reduceMethod} that corresponds to a filtering statistics
  the current default is 1000 (or the length of the number of features, if
  less). For a dimensionality reduction saved in the reducedDims slot the
  default is 50 or the maximum number of dimensions if less than 50.

\code{reduceMethod} will first be checked to see if it corresponds
  with an existing saved filtering statistic or a dimensionality reduction to
  determine which of these two types it is. If it does not match either, then
  it will be checked against the built in functions provided by the package.
  @examples 
  se<-SingleCellExperiment(matrix(rnorm(5000*100),nrow=5000,ncol=100))
  defaultNDims(se,"PCA")
  defaultNDims(se,"mad")

\code{whichClusterIgnoreUnassigned} is only an option when applied
  to a \code{ClusterExperiment} classs and indicates that the filtering
  statistics should be calculated based on samples that are unassigned by the
  designated clustering. The name given to the filter in this case is of the
  form \code{<filterStats>_<clusterLabel>}, i.e. the clustering label of the
  clustering is appended to the standard name for the filtering statistic.

Note that \code{filterData} returns a SingleCellExperiment object.
  To get the actual data out use either assay or \code{\link{transformData}}
  if transformed data is desired.

The PCA method uses either \code{prcomp} from the \code{stats}
  package or  \code{svds} from the \code{RSpectra} package to perform PCA.
  Both are called on \code{t(assay(x))} with \code{center=TRUE} and
  \code{scale=TRUE} (i.e. the feature are centered and scaled), so that it is
  performing PCA on the correlation matrix of the features.

Note that this function does not check if such a reduceDim value already exists, and will recalculate (and overwrite) if it does.
}
\examples{
data(simData)
listBuiltInFilterStats()
scf<-makeFilterStats(simData,filterStats=c("var","mad"))
scf
scfFiltered<-filterData(scf,filterStats="mad",percentile=10)
scfFiltered
assay(scfFiltered)[1:10,1:10]
data(simData)
listBuiltInReducedDims()
scf<-makeReducedDims(simData, reducedDims="PCA", maxDims=3)
scf
}
\seealso{
\code{\link{makeFilterStats}},\code{\link{makeReducedDims}},
  \code{\link{filterData}}, \code{\link[SingleCellExperiment]{reducedDim}}
}
