% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gseAnalyzer.R
\name{gseMKEGG}
\alias{gseMKEGG}
\title{gseMKEGG}
\usage{
gseMKEGG(
  geneList,
  organism = "hsa",
  keyType = "kegg",
  exponent = 1,
  minGSSize = 10,
  maxGSSize = 500,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  verbose = TRUE,
  nPerm = 1000,
  method = "multilevel",
  adaptive = FALSE,
  minPerm = 101,
  maxPerm = 1e+05,
  pvalThreshold = 0.1,
  ...
)
}
\arguments{
\item{geneList}{order ranked geneList}

\item{organism}{supported organism listed in 'https://www.genome.jp/kegg/catalog/org_list.html'}

\item{keyType}{one of "kegg", 'ncbi-geneid', 'ncib-proteinid' and 'uniprot'}

\item{exponent}{weight of each step}

\item{minGSSize}{minimal size of each geneSet for analyzing}

\item{maxGSSize}{maximal size of genes annotated for testing}

\item{pvalueCutoff}{pvalue Cutoff}

\item{pAdjustMethod}{pvalue adjustment method}

\item{verbose}{print message or not}

\item{nPerm}{The number of permutations.}

\item{method}{method of calculating the pvalue, one of "multilevel", "monte carlo" and "fgsea"}

\item{adaptive}{logical, whether to use adaptive method for calculating pvalue}

\item{minPerm}{minimal number of permutations for adaptive method}

\item{maxPerm}{maximal number of permutations for adaptive method}

\item{pvalThreshold}{pvalue threshold for adaptive method}

\item{...}{other parameter}
}
\value{
gseaResult object
}
\description{
Gene Set Enrichment Analysis of KEGG Module
}
\author{
Yu Guangchuang
}
