% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/io.R
\name{parse.gctx}
\alias{parse.gctx}
\alias{parse_gctx}
\title{Parse a GCTX file into the workspace as a GCT object}
\usage{
parse.gctx(...)

parse_gctx(fname, rid = NULL, cid = NULL, matrix_only = FALSE)
}
\arguments{
\item{...}{arguments passed on to \code{parse_gctx}}

\item{fname}{path to the GCTX file on disk}

\item{rid}{either a vector of character or integer
row indices or a path to a grp file containing character
row indices. Only these indicies will be parsed from the
file.}

\item{cid}{either a vector of character or integer
column indices or a path to a grp file containing character
column indices. Only these indicies will be parsed from the
file.}

\item{matrix_only}{boolean indicating whether to parse only
the matrix (ignoring row and column annotations)}
}
\value{
a GCT object
}
\description{
Parse a GCTX file into the workspace as a GCT object
}
\details{
\code{parse_gctx} also supports parsing of plain text
  GCT files, so this function can be used as a general GCT parser.
}
\examples{
gct_file <- system.file("extdata", "modzs_n25x50.gctx", package="cmapR")
(ds <- parse_gctx(gct_file))

# matrix only
(ds <- parse_gctx(gct_file, matrix_only=TRUE))

# only the first 10 rows and columns
(ds <- parse_gctx(gct_file, rid=1:10, cid=1:10))

}
\seealso{
Other GCTX parsing functions: 
\code{\link{GCT}},
\code{\link{append.dim}()},
\code{\link{fix.datatypes}()},
\code{\link{process_ids}()},
\code{\link{read.gctx.ids}()},
\code{\link{read.gctx.meta}()},
\code{\link{write.gctx.meta}()},
\code{\link{write.gctx}()},
\code{\link{write.gct}()}
}
\concept{GCTX parsing functions}
