% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoMethAllRegions.R
\name{CoMethAllRegions}
\alias{CoMethAllRegions}
\title{Extract contiguous co-methylated genomic regions from a list of
  pre-defined genomic regions}
\usage{
CoMethAllRegions(
  dnam,
  betaToM = FALSE,
  method = c("pearson", "spearman"),
  rDropThresh_num = 0.4,
  minCpGs = 3,
  genome = c("hg19", "hg38"),
  arrayType = c("450k", "EPIC"),
  CpGs_ls,
  file = NULL,
  returnAllCpGs = FALSE,
  output = c("CpGs", "dataframe"),
  nCores_int = 1L,
  ...
)
}
\arguments{
\item{dnam}{matrix (or data frame) of beta values, with row names = CpG IDs,
column names = sample IDs. This is typically genome-wide methylation beta
values.}

\item{betaToM}{indicates if converting methylation beta values to mvalues}

\item{method}{method for computing correlation,
can be "spearman" or "pearson"}

\item{rDropThresh_num}{threshold for min correlation between a cpg with sum
of the rest of the CpGs}

\item{minCpGs}{minimum number of CpGs to be considered a "region".
Only regions with more than \code{minCpGs} will be returned.}

\item{genome}{Human genome of reference hg19 or hg38}

\item{arrayType}{Type of array, can be "450k" or "EPIC"}

\item{CpGs_ls}{list where each item is a character vector of CpGs IDs.
This should be CpG probes located closely on the array.}

\item{file}{an RDS file with clusters of CpG locations (i.e. CpGs
located closely to each other on the genome). This file can be generated
by the \code{\link{WriteCloseByAllRegions}} function.}

\item{returnAllCpGs}{When there is not a contiguous comethylated region in
the inputting pre-defined region, \code{returnAllCpGs = TRUE} indicates
outputting all the CpGs in the input regions (regardless of statistical
significance), while \code{returnAllCpGs = FALSE} indicates not returning
any CpGs not contained in comethylated clusters. Defaults to \code{FALSE},
and we provide this option for debugging purposes only.}

\item{output}{a character vector of CpGs or a dataframe of CpGs along with
rDrop info}

\item{nCores_int}{Number of computing cores to be used when executing code
in parallel. Defaults to 1 (serial computing).}

\item{...}{Dots for additional arguments passed to the cluster constructor.
See \code{\link{CreateParallelWorkers}} for more information.}
}
\value{
When \code{output = "dataframe"} is selected, returns a list of data
   frames, each with \code{CpG} (CpG name), \code{Chr} (chromosome number),
   \code{MAPINFO} (genomic position), \code{r_drop} (correlation between the
   CpG with rest of the CpGs), \code{keep} (indicator for co-methylated CpG),
   \code{keep_contiguous} (index for contiguous comethylated subregions).

   When \code{output = "CpGs"} is selected, returns a list, each item is a
   list of CpGs in the contiguous co-methylated subregion.
}
\description{
Extract contiguous co-methylated genomic regions from a list of
  pre-defined genomic regions
}
\details{
There are two ways to input genomic regions for this function: (1)
   use \code{CpGs_ls} argument, or (2) use \code{file} argument. Examples of
   these files are in /inst/extdata/ folder of the package.
}
\examples{
   data(betasChr22_df)


   CpGisland_ls <- readRDS(
     system.file(
       "extdata",
       "CpGislandsChr22_ex.rds",
       package = 'coMethDMR',
       mustWork = TRUE
     )
   )

   coMeth_ls <- CoMethAllRegions (
     dnam = betasChr22_df,
     betaToM = TRUE,
     method = "pearson",
     CpGs_ls = CpGisland_ls,
     arrayType = "450k",
     returnAllCpGs = FALSE,
     output = "CpGs"
   )


}
