% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_CreateParallelWorkers.R
\name{CreateParallelWorkers}
\alias{CreateParallelWorkers}
\title{Create a Parallel Computing Cluster}
\usage{
CreateParallelWorkers(nCores, ...)
}
\arguments{
\item{nCores}{The number of computing cores to make available for coMethDMR
computation}

\item{...}{Additional arguments passed to the cluster constructors.}
}
\value{
A parameter class for use in parallel evaluation
}
\description{
This function is an operating-system agnostic wrapper for the
  \code{\link[BiocParallel]{SnowParam}} and
   \code{\link[BiocParallel]{MulticoreParam}} constructor functions.
}
\details{
This function checks the operating system and then creates a
  cluster of workers using the \code{SnowParam} function for Windows machines
  and the \code{MulticoreParam} function for non-Windows machines.
}
\examples{
   workers_cl <- CreateParallelWorkers(nCores = 4)
   
}
