% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarkComethylatedCpGs.R
\name{MarkComethylatedCpGs}
\alias{MarkComethylatedCpGs}
\title{Mark CpGs in contiguous and co-methylated region}
\usage{
MarkComethylatedCpGs(
  betaCluster_mat,
  betaToM = TRUE,
  epsilon = 1e-08,
  rDropThresh_num = 0.4,
  method = c("pearson", "spearman"),
  use = "complete.obs"
)
}
\arguments{
\item{betaCluster_mat}{matrix of beta values, with rownames = sample ids and
column names = CpG ids. Note that the CpGs need to be ordered by their
genomic positions, this can be accomplished by the
\code{OrderCpGbyLocation} function.}

\item{betaToM}{indicates if beta values should be converted to M values
before computing correlations. Defaults to TRUE.}

\item{epsilon}{When transforming beta values to M values, what should be done
to values exactly equal to 0 or 1? The M value transformation would yield
\code{-Inf} or \code{Inf} which causes issues in the statistical model. We
 thus replace all values exactly equal to 0 with 0 + \code{epsilon}, and
 we replace all values exactly equal to 1 with 1 - \code{epsilon}. Defaults
 to \code{epsilon = 1e-08}.}

\item{rDropThresh_num}{threshold for minimum correlation between a cpg with
the rest of the CpGs. Defaults to 0.4.}

\item{method}{correlation method; can be "pearson" or "spearman"}

\item{use}{method for handling missing values when calculating the
correlation. Defaults to \code{"complete.obs"} because the option
\code{"pairwise.complete.obs"} only works for Pearson correlation.}
}
\value{
A data frame with the following columns:
  \itemize{
    \item{\code{CpG} : }{CpG ID}
    \item{\code{keep} : }{The CpGs with \code{keep = 1} belong to the
      contiguous and co-methylated region}
    \item{\code{ind} : }{Index for the CpGs}
    \item{\code{r_drop} : }{The correlation between each CpG with the sum of
      the rest of the CpGs}
  }
}
\description{
Mark CpGs in contiguous and co-methylated region
}
\details{
An outlier CpG in a genomic region will typically have low
  correlation with the rest of the CpGs in a genomic region. On the other
  hand, in a cluster of co-methylated CpGs, we expect each CpG to have high
  correlation with the rest of the CpGs. The \code{r.drop} statistic is used
  to identify these co-methylated CpGs here.
}
\examples{
   data(betaMatrix_ex1)
   
   MarkComethylatedCpGs(
     betaCluster_mat = betaMatrix_ex1,
     betaToM = FALSE,
     method = "pearson"
   )
   
}
