% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogena.R
\docType{package}
\name{cogena_package}
\alias{cogena_package}
\alias{cogena}
\alias{cogean_package}
\title{Co-expressed gene set enrichment analysis}
\source{
https://github.com/zhilongjia/cogena
}
\description{
To discovery smaller scale, but highly correlated cellular events 
that may be of great biological relevance, co-expressed gene set 
enrichment analysis, cogena, clusters gene expression profiles (coExp) and
then make enrichment analysis for each clusters (clEnrich) 
based on hyper-geometric test. The heatmapCluster and heatmapPEI can
visualise the results. See vignette for the detailed workflow.
}
\examples{

## A quick start

# Loading the examplar dataseat
data(Psoriasis)

# Clustering the gene expression profiling
clMethods <- c("hierarchical","kmeans","diana","fanny","som","model","sota","pam","clara","agnes")
genecl_result <- coExp(DEexprs, nClust=5:6, clMethods=clMethods, 
    metric="correlation", method="complete", ncore=2, verbose=TRUE)

# Gene set used
annofile <- system.file("extdata", "c2.cp.kegg.v7.01.symbols.gmt.xz", package="cogena")

# Enrichment analysis for clusters
clen_res <- clEnrich(genecl_result, annofile=annofile, sampleLabel=sampleLabel)

summary(clen_res)


# Visualisation
heatmapCluster(clen_res, "hierarchical", "6")
heatmapPEI(clen_res, "hierarchical", "6", printGS=FALSE)

# Obtain genes in a certain cluster
head(geneInCluster(clen_res, "hierarchical", "6", "2"))

## The end

}
\keyword{package}
