% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_import.R
\name{read_orthofinder_stats}
\alias{read_orthofinder_stats}
\title{Read and parse Orthofinder summary statistics}
\usage{
read_orthofinder_stats(stats_dir = NULL)
}
\arguments{
\item{stats_dir}{Path to directory containing Orthofinder's comparative
genomics statistics. In your Orthofinder results directory, this directory
is named \strong{Comparative_Genomics_Statistics}.}
}
\value{
A list of data frames with the following elements:
\enumerate{
\item \strong{stats} A data frame of summary stats per species with
the following variables:
\describe{
\item{Species}{Factor of species names.}
\item{N_genes}{Numeric of number of genes.}
\item{N_genes_in_OGs}{Numeric of number of genes in orthogroups.}
\item{Perc_genes_in_OGs}{Numeric of percentage of genes in orthogroups.}
\item{N_ssOGs}{Numeric of number of species-specific orthogroups.}
\item{N_genes_in_ssOGs}{Numeric of number of genes in species-specific
orthogroups.}
\item{Perc_genes_in_ssOGs}{Numeric of percentage of genes in
species-specific orthogroups.}
\item{Dups}{Integer with number of duplications per species.}
}

\item \strong{og_overlap} A symmetric data frame of pairwise
orthogroup overlap between species.
\item \strong{duplications} A 2-column data frame with node IDs
in the first column and number of gene duplications (50\% support)
in the second column.
}
}
\description{
Read and parse Orthofinder summary statistics
}
\examples{
stats_dir <- system.file("extdata", package = "cogeqc")
ortho_stats <- read_orthofinder_stats(stats_dir)
}
