% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{CNV.data-class}
\alias{CNV.data-class}
\alias{show,CNV.data-method}
\alias{[,CNV.data,ANY,ANY,ANY-method}
\alias{names,CNV.data-method}
\alias{names<-,CNV.data-method}
\title{CNV.data class}
\usage{
\S4method{show}{CNV.data}(object)

\S4method{[}{CNV.data,ANY,ANY,ANY}(x, i)

\S4method{names}{CNV.data}(x)

\S4method{names}{CNV.data}(x) <- value
}
\arguments{
\item{object}{\code{CNV.data} object}

\item{x}{\code{CNV.data} object (defined by \code{Extract} generic).}

\item{i}{index. \code{logical}, \code{numeric} or \code{character}.}

\item{value}{Replacement names.}
}
\value{
\code{CNV.data} class.
}
\description{
Intensities of one or multiple samples are stored in this class.
}
\details{
Use \code{CNV.load} to create.
}
\examples{
# create object
library(minfiData)
data(MsetEx)

d <- CNV.load(MsetEx)

# general information
d
show(d)

# show or replace sample names
names(d)
names(d) <- toupper(names(d))

# subset samples
d[1:2]
}
\author{
Volker Hovestadt \email{conumee@hovestadt.bio}
}
