% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{earthmover_dist}
\alias{earthmover_dist}
\title{Earthmover distance (and general Wasserstein distance)}
\usage{
earthmover_dist(batch1, batch2, whichdim = 1, numbins = 100, p_param = 1)
}
\arguments{
\item{batch1}{matrix; subset of observations from an embedding correponding to some attribute (e.g., batch or phenotype)}

\item{batch2}{matrix; subset of observations from an embedding correponding to some attribute (e.g., batch or phenotype)}

\item{whichdim}{int; which dimension (i.e., column) from the embeddings is used. defaults on first}

\item{numbins}{int; number of bins for the probability discretization (defaults to 100)}

\item{p_param}{int; penalty parameter for general Wasserstein distance. Defaults to 1, which corresonds to earthmover.}
}
\value{
num; the distance
}
\description{
i.e., wasserstein distance with L1 (p_param = 1); can also use other penalties > 1
(Not technically earthmover distance if using other p_param values)
}
\examples{
# To compare distributions of reduced dimension values to assess similarity, 
# e.g. as a metric for batch integration
embedding <- matrix(sample(x = seq(0,10,.1),1000, replace = TRUE),ncol = 5)
batch <- matrix(sample(c(1,2),200, replace = TRUE))
earthmover_dist(embedding[which(batch == 1),],embedding[which(batch == 2),]) 
}
