% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addCompositeScores.R
\name{addCompositeScores}
\alias{addCompositeScores}
\alias{addCompositeScores,GuideSet-method}
\alias{addCompositeScores,PairedGuideSet-method}
\alias{addCompositeScores,NULL-method}
\title{Add on-target composite score to a \linkS4class{GuideSet} object.}
\usage{
addCompositeScores(object, ...)

\S4method{addCompositeScores}{GuideSet}(
  object,
  methods = c("ruleset1", "ruleset3", "lindel", "deephf", "enpamgb", "casrxrf",
    "crisprater", "crisprscan"),
  scoreName = "score_composite"
)

\S4method{addCompositeScores}{PairedGuideSet}(
  object,
  methods = c("ruleset1", "ruleset3", "lindel", "deephf", "enpamgb", "crisprater",
    "crisprscan", "casrxrf"),
  scoreName = "score_composite"
)

\S4method{addCompositeScores}{NULL}(object)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{methods}{Character vector specifying method names for on-target
efficiency prediction algorithms to be used to create the composite
score. Note that the specified scores must be added first to the
object using \code{addOnTargetScores}.}

\item{scoreName}{String specifying the name of the composite score to
be used as a columm name. Users can choose whatever they like. 
Default is "score_composite".}
}
\value{
\code{guideSet} with column specified by \code{scoreName} 
    appended in \code{mcols(guideSet)}.
}
\description{
Add on-target composite score to a \linkS4class{GuideSet}
    object.
}
\details{
The function creates a composite score across a specified list
    of on-target scores by first transforming each individual score into
    a rank, and then taking the average rank across all specified methods.
    This can improve on-target activity prediction robustness. 
    A higher score indicates higher on-target activity.
}
\examples{
gs <- findSpacers("CCAACATAGTGAAACCACGTCTCTATAAAGAATAAAAAATTAGCCGGGTTA")
gs <- addOnTargetScores(gs, methods=c("ruleset1", "crisprater"))
gs <- addCompositeScores(gs, methods=c("ruleset1", "crisprater"))

}
\seealso{
\code{\link{addOnTargetScores}} to add on-target scores.
}
\author{
Jean-Philippe Fortin
}
