% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GuideSet2DataFrames.R
\name{flattenGuideSet}
\alias{flattenGuideSet}
\title{Create a list of annotation tables from a GuideSet object}
\usage{
flattenGuideSet(guideSet, useSpacerCoordinates = TRUE, primaryOnly = FALSE)
}
\arguments{
\item{guideSet}{A GuideSet object}

\item{useSpacerCoordinates}{Should the spacer coordinates be used
as start and end coordinates? TRUE by default. If FALSE,
the PAM site coordinate is used for both start and end.}

\item{primaryOnly}{Should only the primary table (on-targets) be returned?
FALSE by default.}
}
\value{
A simple list of tables containing annotations derived from a 
    GuideSet object. The first table ("primary") is always available,
    while the other tables will be only available when the annotations
    were added to the GuideSet object. 

\itemize{
\item \code{primary} Primary table containing genomic coordinates and 
     sequence information of the gRNA sequences. Also contains on-target
     and off-target scores when available. 
\item \code{alignments} Table of on- and off-target alignments.
\item \code{geneAnnotation} Gene context annotation table.
\item \code{tssAnnotation} TSS context annotation table.
\item \code{enzymeAnnotation} Boolean table indicating whether or not 
    recognition motifs of restriction enzymes are found. 
\item \code{snps} SNP annotation table (human only).
}
}
\description{
Create a list of annotation tables from a GuideSet object
}
\author{
Jean-Philippe Fortin
}
