% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addEditedAlleles.R
\name{addEditedAlleles}
\alias{addEditedAlleles}
\title{To add edited alleles for a CRISPR base editing GuideSet}
\usage{
addEditedAlleles(
  guideSet,
  baseEditor,
  editingWindow = NULL,
  nMaxAlleles = 100,
  minEditingWeight = 0,
  minMutationScore = 0.3,
  addFunctionalConsequence = TRUE,
  addSummary = TRUE,
  txTable = NULL,
  verbose = TRUE
)
}
\arguments{
\item{guideSet}{A \linkS4class{GuideSet} object.}

\item{baseEditor}{A \linkS4class{BaseEditor} object.}

\item{editingWindow}{A numeric vector of length 2 specifying
start and end positions of the editing window with 
respect to the PAM site. If \code{NULL} (default),
the editing window of the \code{BaseEditor} object
will be considered.}

\item{nMaxAlleles}{Maximum number of edited alleles to report
for each gRNA. Alleles from high to low scores.
100 by default.}

\item{minEditingWeight}{Numeric value indicating the minimum editing weight
required for an edited allele to be listed. Default of 0.}

\item{minMutationScore}{Numeric value indicating the minimum editing score that
an allele must have to call a mutation. Default of "0.3".}

\item{addFunctionalConsequence}{Should variant classification
of the edited alleles be added? TRUE by default.
If \code{TRUE}, \code{txTable} must be provided.}

\item{addSummary}{Should a summary of the variant classification
be added to the metadata columns of the \code{guideSet}
object? TRUE by default.}

\item{txTable}{Table of transcript-level nucleotide and amino
acid information needed for variant classification.
Usually returned by \code{\link{getTxInfoDataFrame}}.}

\item{verbose}{Should messages be printed to console?
TRUE by default.}
}
\value{
The original \code{guideSet} object with an additional
    metadata column (\code{editedAlleles}) storing the annotated
    edited alelles. The edited alleles are always reported 
    from 5' to 3' direction on the strand corresponding to the
    gRNA strand.
}
\description{
To add edited alleles for a CRISPR base editing GuideSet.
}
\examples{

data(BE4max, package="crisprBase")
data(grListExample, package="crisprDesign")
library(BSgenome.Hsapiens.UCSC.hg38)
bsgenome <- BSgenome.Hsapiens.UCSC.hg38
gr <- queryTxObject(grListExample,
                    featureType="cds",
                    queryColumn="gene_symbol",
                    queryValue="IQSEC3")
gs <- findSpacers(gr[1],
                  crisprNuclease=BE4max,
                  bsgenome=bsgenome)
gs <- unique(gs)
gs <- gs[1:2] # For the sake of time

# Getting transcript info:
txid="ENST00000538872"
txTable <- getTxInfoDataFrame(tx_id=txid,
    txObject=grListExample,
    bsgenome=bsgenome)

#Adding alelles:
editingWindow <- c(-20,-8)
gs <- addEditedAlleles(gs,
                       baseEditor=BE4max,
                       txTable=txTable,
                       editingWindow=editingWindow)

}
\author{
Jean-Philippe Fortin
}
