% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designCompleteAnnotation.R
\name{designCompleteAnnotation}
\alias{designCompleteAnnotation}
\title{One-step gRNA design and annotation function}
\usage{
designCompleteAnnotation(
  queryValue = NULL,
  queryColumn = "gene_id",
  featureType = "cds",
  modality = c("CRISPRko", "CRISPRa", "CRISPRi", "CRISPRkd"),
  bsgenome = NULL,
  bowtie_index = NULL,
  vcf = NULL,
  crisprNuclease = NULL,
  tssObject = NULL,
  txObject = NULL,
  grRepeats = NULL,
  scoring_methods = NULL,
  tss_window = NULL,
  n_mismatches = 3,
  max_mm = 2,
  canonical_ontarget = TRUE,
  canonical_offtarget = FALSE,
  all_alignments = TRUE,
  conservationFile = NULL,
  nucExtension = 9,
  binaries = NULL,
  canonicalIsoforms = NULL,
  pfamTable = NULL,
  verbose = TRUE
)
}
\arguments{
\item{queryValue}{Vector specifying the value(s) to search for in
\code{txObject[[featureType]][[queryColumn]]}.}

\item{queryColumn}{Character string specifying the column in 
\code{txObject[[featureType]]} to search for \code{queryValue}(s).}

\item{featureType}{For CRISPRko, string specifying the type of genomic
feature to use to design gRNAs. Must be of the following:
"transcripts", "exons", "cds", "fiveUTRs", "threeUTRs" or "introns".
The default is "cds".}

\item{modality}{String specifying the CRISPR modality. Must be one of
the following: "CRISPRko", "CRISPRa", "CRISPRi" or "CRISPRkd".
CRISPRkd is reserved for DNA-targeting nucleases only such as CasRx.}

\item{bsgenome}{A \linkS4class{BSgenome} object from which to extract
sequences if a \linkS4class{GRanges} object is provided as input.}

\item{bowtie_index}{String specifying path to a bowtie index.}

\item{vcf}{Either a character string specfying a path to a VCF file
or connection, or a \linkS4class{VCF} object.}

\item{crisprNuclease}{A \linkS4class{CrisprNuclease} object.}

\item{tssObject}{A \linkS4class{GRanges} object specifying TSS coordinates.}

\item{txObject}{A \linkS4class{TxDb} object or a \linkS4class{GRangesList}
object obtained using \code{\link{TxDb2GRangesList}} for annotating
on-target and off-target alignments using gene annotation.}

\item{grRepeats}{A \linkS4class{GRanges} object containing repeat
elements regions.}

\item{scoring_methods}{Character vector to specify which on-target scoring
methods should be calculated. See crisprScore package to obtain
available methods.}

\item{tss_window}{Vector of length 2 specifying the start and coordinates
of the CRISPRa/CRISPRi target region with respect to the TSS position.}

\item{n_mismatches}{Maximum number of mismatches permitted between guide RNA
and genomic DNA.}

\item{max_mm}{The maximimum number of mismatches between a spacer and
an off-target to be accepted when calculating aggregate off-target
scores. 2 by default.}

\item{canonical_ontarget}{Should only canonical PAM sequences be searched
for designing gRNAs? TRUE by default.}

\item{canonical_offtarget}{Should only canonical PAM sequences by searched
during the off-target search? TRUE by default.}

\item{all_alignments}{Should all all possible alignments be returned?
TRUE by default.}

\item{conservationFile}{String specifing the BigWig file containing
conservation scores.}

\item{nucExtension}{Number of nucleotides to include on each side of the 
cut site to calculate the conservation score. 9 by default. 
The region will have (2*nucExtension + 1) nucleotides in total.}

\item{binaries}{Named list of paths for binaries needed for 
CasRx-RF. Names of the list must be "RNAfold", "RNAhybrid",
and "RNAplfold". Each list element is a string specifying
the path of the binary. If NULL (default), binaries must be
available on the PATH.}

\item{canonicalIsoforms}{Optional data.frame with 2 columns detailing
Ensembl canonical isoforms. First column must be named "tx_id",
and second column must be named "gene_id", corresponding to
Ensembl transcript and gene ids, respectively.}

\item{pfamTable}{A \linkS4class{DataFrame} obtained using
\code{\link{preparePfamTable}}.}

\item{verbose}{Should messages be printed?}
}
\value{
A \code{GuideSet} object.
}
\description{
One-step gRNA design and annotation function
   to faciliate the design and generation of genome-wide
   gRNA databases for a combination of parameters such 
   as nuclease, organism, and CRISPR modality.
}
\author{
Jean-Philippe Fortin
}
