% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMrnaSequence.R
\name{getMrnaSequences}
\alias{getMrnaSequences}
\title{Retrieve mRNA sequences}
\usage{
getMrnaSequences(txids, txObject, bsgenome)
}
\arguments{
\item{txids}{A character vector of Ensembl transcript IDs. IDs not present
in \code{txObject} will be silently ignored.}

\item{txObject}{A \linkS4class{TxDb} object or a \linkS4class{GRangesList}
object obtained from \code{\link{TxDb2GRangesList}}. Defines genomic
ranges for \code{txids}.}

\item{bsgenome}{A \linkS4class{BSgenome} object from which to extract
mRNA sequences.}
}
\value{
A \linkS4class{DNAStringSet} object of mRNA sequences. Note that
    sequences are returned as DNA rather than RNA.
}
\description{
A function for retrieving mRNA sequences of select transcripts.
}
\examples{

library(BSgenome.Hsapiens.UCSC.hg38)
data(grListExample)
bsgenome <- BSgenome.Hsapiens.UCSC.hg38
txids <- c("ENST00000538872", "ENST00000382841")
out <- getMrnaSequences(txids, grListExample, bsgenome)

}
\author{
Jean-Philippe Fortin
}
