% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankSpacers.R
\name{rankSpacers}
\alias{rankSpacers}
\title{Recommended gRNA ranking}
\usage{
rankSpacers(
  guideSet,
  tx_id = NULL,
  commonExon = FALSE,
  modality = c("CRISPRko", "CRISPRa", "CRISPRi"),
  useDistanceToTss = TRUE
)
}
\arguments{
\item{guideSet}{A \linkS4class{GuideSet} object.}

\item{tx_id}{Optional string specifying transcript ID to use
isoform-specific information for gRNA ranking.}

\item{commonExon}{Should gRNAs targeting common exons by prioritized?
FALSE by default. If TRUE, \code{tx_id} must be provided.}

\item{modality}{String specifying the CRISPR modality. Should be one
of the following: "CRISPRko", "CRISPRa", or "CRISPRi".}

\item{useDistanceToTss}{Should distance to TSS be used to rank gRNAs 
for CRISPRa and CRISPRi applications? TRUE by default. 
For SpCas9 and human targets, this should be set to FALSE if
\code{addCrispraiScores} was used.}
}
\value{
A \linkS4class{GuideSet} object ranked from best to worst gRNAs,
    with a column \code{rank} stored in \code{mcols(guideSet)} indicating
    gRNA rank.
}
\description{
Function for ranking spacers using 
    recommended crisprDesign criteria. CRISPRko, CRISPRa and CRISPRi
    modalities are supported.
}
\details{
For each nuclease, we rank gRNAs based on several rounds of priority.
    For SpCas9, gRNAs with unique target sequences and without 
    1-or 2-mismatch off-targets located in coding regions are placed into 
    the first round. Then, gRNAs with a small number of one- or 
    two-mismatch off-targets  (less than 5) are placed into the second 
    round. Remaining gRNAs are placed into the third round. Finally, 
    any gRNAs overlapping a common SNP (human only), containing a polyT 
    stretch, or with extreme GC content (below 20% of above 80%) 
    are placed into the fourth round.

    If \code{tx_id} is specified, within each round of selection, gRNAs 
    targeting the first 85 percent of the specific transcript are 
    prioritized first. If \code{tx_id} is specified, and \code{commonExon}
    is set to TRUE, gRNAs targeting common exons across isoforms are also
    prioritized. If a conservation score is available, gRNAs
    targeting conserved regions (phyloP conservation score greater than 0), 
    are also prioritized.

    Within each bin, gRNAs are ranked by a composite 
    on-target activity rank to prioritize active gRNAs. The composite
    on-target activity rank is calculated by taking the average rank
    across the DeepHF and RuleSet3 scores for CRISPRko.
    For CRISPRa or CRISPRi, the CRISPRai scores are used if available.

    The process is identical for enAsCas12a, with the exception that the 
    enPAMGb method is used as the composite score.

    For CasRx, gRNAs targeting all isoforms of a given gene, with no 1- or 
    2-mismatch off-targets, are placed into the first round. gRNAs
    targeting at least 50 percent of the isoforms of a given gene, with 
    no 1- or 2-mismatch off-targets, are placed into the second round. 
    Remaining gRNAs are placed into the third round. Within each
    round of selection, gRNAs are further ranked by the CasRxRF
    on-target score.
}
\examples{
data(guideSetExampleFullAnnotation, package="crisprDesign")
gs <- rankSpacers(guideSetExampleFullAnnotation,
                  tx_id = "ENST00000538872")
gs

}
\author{
Luke Hoberecht, Jean-Philippe Fortin
}
