% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{buildClusterTree}
\alias{buildClusterTree}
\title{Perform hierarchical clustering on reducedDim}
\usage{
buildClusterTree(
  sce,
  reduction,
  labelCol,
  method.dist = c("cosine", "euclidean", "maximum", "manhattan", "canberra", "binary",
    "minkowski"),
  method.hclust = c("complete", "ward.D", "ward.D2")
)
}
\arguments{
\item{sce}{\code{SingleCellExperiment} object}

\item{reduction}{field of reducedDims(sce) to use}

\item{labelCol}{column in \code{SingleCellExperiment} storing cell type annotations}

\item{method.dist}{method for \code{dist(..,method=method.dist)}}

\item{method.hclust}{method for \code{hclust(..,method=method.hclust)}}
}
\value{
hierarchical clustering computed by \code{hclust()}
}
\description{
Perform hierarchical clustering dimension reduction from single cell expression data
}
\examples{
library(muscat)

data(example_sce)

hcl_test = buildClusterTree(example_sce, "TSNE", "cluster_id")

}
