#' Removes negative values from the expression matrix
#'
#' @param x is the flowframe whose expression matrix contains negative values
#' @return flowframe with non-negative values in its expression matrix
#'
#' @examples
#' flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
#' package = "cyanoFilter",
#' mustWork = TRUE)
#' flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
#'                                transformation = FALSE, emptyValue = FALSE,
#'                                dataset = 1) 
#' flowfile_nona <- cyanoFilter::noNA(x = flowfile)
#' noNeg(x = flowfile_nona)
#'
#'
#'@importFrom methods new
#'@export noNeg

noNeg <- function(x) {
    dtest <- !apply(flowCore::exprs(x), 1, function(row) any(row <= 0))
    exx <- flowCore::exprs(x)[dtest == TRUE, ]
    paraa <- flowCore::parameters(x)
    describe <- flowCore::keyword(x)
    return(flowCore::flowFrame(exprs = exx, parameters = paraa, 
                               description = describe))
}
