% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareCellData.R
\name{prepareCellData}
\alias{prepareCellData}
\title{Prepare mass cytometry data}
\usage{
prepareCellData(x, markers = NULL, ...)
}
\arguments{
\item{x}{A named list of numeric matrices, 
where each matrix corresponds to a sample and contains expression intensities for each cell (row) and each marker (column).

Alternatively, a ncdfFlowSet object containing the same information.}

\item{markers}{A character vector containing the names of the markers to use in downstream analyses.}

\item{...}{Additional arguments to pass to \code{\link{buildIndex}}.}
}
\value{
A \linkS4class{List} containing precomputed values for use in \code{\link{countCells}}.
This includes:
\itemize{
\item \code{precomputed}, a prebuilt index for the neighbor search.
\item \code{sample.id}, an integer vector specifying the sample of origin for each cell in \code{precomputed}.
\item \code{cell.id}, an integer vector specifying the original index in 
the corresponding sample of \code{x} for each cell in \code{precomputed}.
\item \code{unused}, a matrix of intensity values for markers \emph{not} in \code{markers}.
\item \code{colData}, a \linkS4class{DataFrame} containing per-sample statistics.
}
}
\description{
Convert single-cell marker intensities from a mass cytometry experiment into a format for efficient counting.
}
\details{
This function constructs a neighbor search index from the marker intensities of each cell in one or more samples.
The precomputed index is used to speed up downstream nearest-neighbour searching,
avoiding redundant work from repeated calls to \code{\link{countCells}} (e.g., with different values of \code{tol}).

If \code{markers} is specified, only the selected markers will be used in the precomputation.
This restricts the markers that are used in downstream functions - 
namely, \code{\link{countCells}} and \code{\link{neighborDistances}}.
By default, \code{markers=NULL} which means that all supplied markers will be used.

Markers that are \emph{not} in \code{markers} will be ignored in distance calculations.
However, their intensities are still stored in the output object, for use in functions like \code{\link{medIntensities}}.
}
\examples{
### Mocking up some data: ###
nmarkers <- 20
marker.names <- paste0("X", seq_len(nmarkers))
nsamples <- 8
sample.names <- paste0("Y", seq_len(nsamples))

x <- list()
for (i in sample.names) {
    ex <- matrix(rgamma(nmarkers*1000, 2, 2), ncol=nmarkers, nrow=1000)
    colnames(ex) <- marker.names
    x[[i]] <- ex
}

### Running the function: ###
cd <- prepareCellData(x)
cd

}
\seealso{
\code{\link{countCells}}, where the output of this function is used to obtain hypersphere counts.
}
\author{
Aaron Lun
}
