% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllslotAccessors.R
\docType{methods}
\name{CytoKalpha}
\alias{CytoKalpha}
\alias{CytoKalpha,CytoK-method}
\title{Generic function that returns the CytoK level of
significance (alpha) 
Given a CytoK object, this function returns the
CytoK alpha}
\usage{
CytoKalpha(object)

\S4method{CytoKalpha}{CytoK}(object)
}
\arguments{
\item{object}{an object of class \code{CytoK}.}
}
\value{
Value of \code{CytoKalpha} argument passed 
to \code{CytoK}
}
\description{
Accessors for the 'CytoKalpha'
slot of a CytoK object.
}
\examples{
data <- cbind(matrix(rnorm(1200,mean=2, sd=1.5),
nrow=200, ncol=6), matrix(rnorm(1200,mean=5, sd=1.9),
nrow=200, ncol=6))
data_CytoK <- CytoK(object=data,
group_factor = rep(c(0,1), each=6), lowerRho=2,
upperRho=12,gridRho=4,alpha = 0.05,
featureVars = NULL)
CytoKalpha(data_CytoK)

}
