% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelQC.R
\name{labelQC}
\alias{labelQC}
\title{Returns the final label assignments the specified parameters}
\usage{
labelQC(
  x,
  model = c("svm", "rf", "gbm"),
  type = c("all", "bead", "doublet", "debris", "dead"),
  nTrain = 4000,
  loss = c("auc", "class")
)
}
\arguments{
\item{x}{A \code{SingleCellExperiment} created with \code{\link{readCytof}} 
with the scores and initial columns filled out for the event type of 
interest.}

\item{model}{Type of model to use to do the labeling. Options are 
"svm" for a support vector machine, "gbm" for a gradient boosting
machine, or "rf" for a random forest.}

\item{type}{Types of events to model. Options are "all", "bead", "doublet", 
"debris", and "dead".}

\item{nTrain}{The (maximum) number of data points to use when training a
model to predict event types.}

\item{loss}{Specifies the type of loss used to tune the GBM. Can be either
"auc" for the area under the curve or "class" for classification error. 
This argument is ignored if random forest is used as the model.}
}
\value{
A \code{SingleCellExperiment} data.frame is returned with the 
labels for the parameters of listed in \code{types} (bead, doublet, debris, 
or dead) added to the \code{label} variable and the probabilities for 
each of the columns pertaining to the parameters listed in \code{probs}.
}
\description{
Returns the final label assignments the specified parameters
}
\details{
\code{labelQC} uses a support vector machine, gradient boosting machine, 
or a random forest to compute the final labels
for the specified parameter types (bead, doublet, debris, or dead). 
The predicted probabilities for all of the observations are stored in 
the variable associated with that type for further analysis. Thus, it 
is possible to have a probability greater than 0.5 for 'debris' but still 
have a label of 'bead' if an observation was classified as a bead prior to
classifying the debris.
}
\examples{
data("raw_data", package = "CATALYST")
sce <- readCytof(raw_data, beads = "Beads", viability = c("cisPt1", "cisPt2"))
sce <- labelQC(sce)
table(label(sce))

}
