% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagLogo.R
\name{dagLogo}
\alias{dagLogo}
\title{Create sequence logo.}
\usage{
dagLogo(
  testDAUresults,
  type = c("diff", "zscore"),
  pvalueCutoff = 0.05,
  groupingSymbol = getGroupingSymbol(testDAUresults@group),
  font = "Helvetica",
  fontface = "bold",
  fontsize = 8,
  title = NULL,
  legend = FALSE,
  labelRelativeToAnchor = FALSE,
  labels = NULL,
  alpha = 1,
  markers = list()
)
}
\arguments{
\item{testDAUresults}{An object of \code{\link{testDAUresults-class}}, which
cintains results of testing differential amino acid usage).}

\item{type}{A character vector of length 1. Type of statistics to be displayed 
on y-axis. Available choices are "diff" or "zscore".}

\item{pvalueCutoff}{A numeric vector of length 1. A cutoff of p-values.}

\item{groupingSymbol}{A named character vector.}

\item{font}{A character vector of length 1. Font type for displaying sequence
Logo.}

\item{fontface}{An integer, fontface of text for axis annotation and legends.}

\item{fontsize}{An integer, fontsize of text for axis annotation and legends.}

\item{title}{A character vector of length 1, main title for a plot.}

\item{legend}{A logical vector of length 1, indicating whether to show the 
legend.}

\item{labelRelativeToAnchor}{A logical vector of length 1, indicating whether
x-axis label should be adjusted relative to the anchoring position.}

\item{labels}{A character vector, x-axis labels.}

\item{alpha}{Alpha channel for transparency of low affinity letters.}

\item{markers}{A list of \link[motifStack]{marker-class}.}
}
\value{
A sequence Logo is plotted without returned values.
}
\description{
Create sequence logo for visualizing results of testing differential usage 
of amino acids.
}
\examples{
data('seq.example') 
data('proteome.example')
bg <- buildBackgroundModel(seq.example, proteome=proteome.example, 
                           numSubsamples=10, testType = "ztest")
t0 <- testDAU(seq.example, bg)
t1 <- testDAU(dagPeptides = seq.example, dagBackground = bg, 
              groupingScheme = "hydrophobicity_KD")
t2 <- testDAU(dagPeptides = seq.example, dagBackground = bg, 
             groupingScheme = "charge_group")
t3 <- testDAU(dagPeptides = seq.example, dagBackground = bg, 
             groupingScheme = "chemistry_property_Mahler")
t4 <- testDAU(dagPeptides = seq.example, dagBackground = bg, 
              groupingScheme = "hydrophobicity_KD_group")
dagLogo(t0, markers = list(new("marker", type="rect", start=c(5, 8), 
                                gp=gpar(lty=3, fill=NA)),
                            new("marker", type="text", start=9, label="*", 
                                gp=gpar(col=3))))
dagLogo(t1, groupingSymbol = getGroupingSymbol(t1@group))
dagLogo(t2, groupingSymbol = getGroupingSymbol(t2@group))
dagLogo(t3, groupingSymbol = getGroupingSymbol(t3@group))
dagLogo(t4, groupingSymbol = getGroupingSymbol(t4@group))
}
\author{
Jianhong Ou, Haibo Liu
}
