% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allclass.R
\docType{class}
\name{dagPeptides-class}
\alias{dagPeptides-class}
\alias{dagPeptides}
\title{Class \code{\link{dagPeptides}}.
An S4 class to represent formatted, aligned peptides for dagLogo analysis.}
\description{
Class \code{\link{dagPeptides}}.
An S4 class to represent formatted, aligned peptides for dagLogo analysis.
}
\section{Slots}{

\describe{
\item{\code{data}}{A data frame with column names: IDs, anchorAA, anchorPos, peptide and anchor.}

\item{\code{peptides}}{A matrix of character, each element is a single-character symbol
for a amino acid.}

\item{\code{upstreamOffset}}{An integer, the upstream offset
relative to the anchoring position.}

\item{\code{downstreamOffset}}{An integer, the downstream offset relative to the
anchoring position.}

\item{\code{type}}{A character vector of length 1. Available options :"UniProt", 
and "fasta" if the \code{\link{dagPeptides}} object is generated using 
the function \code{\link{formatSequence}}, or "entrezgene" and 
"uniprotswissprot" if generated by the function \code{\link{fetchSequence}}.}
}}

\section{Objects from the Class}{
 
 Objects can be created by calls of the form 
 
 \code{new("dagPeptides", data, peptides, upstreamOffset, downstreamOffset, type)}.
}

\author{
Jianhong Ou
}
