% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allclass.R
\docType{class}
\name{testDAUresults-class}
\alias{testDAUresults-class}
\alias{testDAUresults}
\title{Class \code{testDAUresults}.}
\description{
An S4 class to represent a DAU statistical test result from dagLogo analysis.
}
\section{Slots}{

\describe{
\item{\code{group}}{A character vector of length 1, the type of method for grouping 
amino acid.}

\item{\code{testType}}{A character vector of length 1, the type of statistic testing.
The available options are "fisher" and "z-test".}

\item{\code{difference}}{A numeric matrix consisting of differences of amino acid 
proportions between the test set and the background set of aligned, formatted 
peptides at each position.}

\item{\code{statistics}}{A numeric matrix consisting of Z-scores or odds ratios for
Z-test and Fisher's exact test, respectively.}

\item{\code{pvalue}}{A numeric matrix consisting of p-values.}

\item{\code{background}}{A numeric matrix consisting of amino acid proportions in the 
background set of aligned, formatted peptides at each position.}

\item{\code{motif}}{A numeric matrix consisting of amino acid proportions at each 
position for visualization by dagLogo.}

\item{\code{upstreamOffset}}{A positive integer, the upstream offset
relative to the anchoring position.}

\item{\code{downstreamOffset}}{A positive integer, the upstream offset
relative to the anchoring position.}
}}

\author{
Jianhong Ou, Haibo Liu
}
