% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe-class.R
\name{prep}
\alias{prep}
\alias{prep,Recipe-method}
\title{Performs all the steps defined in a Recipe}
\usage{
prep(rec, parallel = TRUE, workers = future::availableCores(), force = FALSE)

\S4method{prep}{Recipe}(rec, parallel = TRUE, workers = future::availableCores(), force = FALSE)
}
\arguments{
\item{rec}{A \code{Recipe} object. and furrr packages.}

\item{parallel}{if FALSE, no palatalization. if TRUE, parallel execution
using future and furrr packages.}

\item{workers}{Number of workers for palatalization.}

\item{force}{Force the reexecution of all steps. This remove previous
results.}
}
\value{
A \code{PrepRecipe} object.
}
\description{
For a Recipe with at least one preprocessing or DA operation run the steps in
a convenient order.
}
\examples{
data(metaHIV_phy)

## Define Recipe
rec <-
  recipe(metaHIV_phy, var_info = "RiskGroup2", tax_info = "Class") |>
  step_subset_taxa(tax_level = "Kingdom", taxa = c("Bacteria", "Archaea")) |>
  step_filter_taxa(.f = "function(x) sum(x > 0) >= (0.03 * length(x))") |>
  step_maaslin()

## Prep Recipe
da_results <- prep(rec)

## If you try

## Consensus strategy
n_methods <- 2
da_results <- bake(da_results, count_cutoff = n_methods)
da_results

## If you try to run prep on an object of class PrepRecipe it returns an 
## error.
err <- testthat::expect_error(prep(da_results))
err

## You can force the overwrite with:
prep(rec, force = TRUE)

## This function can operate in parallel thanks to future and furrr packages.
prep(rec, parallel = TRUE, workers = 2)
}
