% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference_methods.R
\name{cor.pairs}
\alias{cor.pairs}
\title{Fast pairwise correlation estimation}
\usage{
cor.pairs(emat, cor.method = c("pearson", "spearman"))
}
\arguments{
\item{emat}{a numeric matrix}

\item{cor.method}{a character, specifying the method to use for estimation.
Possible values are 'pearson' (default) and 'spearman'}
}
\value{
a numeric matrix with estimated correlation coefficients
}
\description{
Fast estimation of pairwise correlation coefficients.
}
\examples{
x <- matrix(rnorm(200), 100, 2)
cor.pairs(x)
cor.pairs(x, cor.method = 'spearman')
}
