% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/Demuxmix-methods.R
\docType{class}
\name{Demuxmix-class}
\alias{Demuxmix-class}
\alias{Demuxmix}
\alias{show,Demuxmix-method}
\alias{summary,Demuxmix-method}
\alias{pAcpt}
\alias{pAcpt,Demuxmix-method}
\alias{pAcpt<-}
\alias{pAcpt<-,Demuxmix,numeric-method}
\title{A class representing a set of mixture models fitted to HTO data}
\usage{
\S4method{show}{Demuxmix}(object)

\S4method{pAcpt}{Demuxmix}(object)

\S4method{pAcpt}{Demuxmix,numeric}(object) <- value

\S4method{summary}{Demuxmix}(object, ...)
}
\arguments{
\item{object}{A \code{Demuxmix} object.}

\item{value}{Value between 0 and 1 specifying the acceptance probability,
i.e., the minimum posterior probability required to assign a droplet to
a hashtag.}

\item{...}{Additional arguments forwarded to summary (ignored).}
}
\value{
An object of class \code{Demuxmix}.
}
\description{
Objects of this class store mixture models fitted to HTO data to demultiplex
oligonucleotide-labeled cells. One mixture model is stored for each hashtag
in the dataset. An object of this class is returned by
\code{\link{demuxmix}}. Users should not directly initialize this class.
There are various methods to extract or plot data from a \code{Demuxmix}
object. Please see the package's vignette for how to work with an object of
this class.
}
\details{
All matrices stored by \code{Demuxmix} have the same dimension and
  the same row and column names as the original matrix \code{hto} passed to
  \code{\link{demuxmix}}. The mixture models in slot \code{models} are
  stored in an internal class format.
}
\section{Functions}{
\itemize{
\item \code{show(Demuxmix)}: Displays the object on the command line.

\item \code{pAcpt(Demuxmix)}: Returns the acceptance probability \code{pAcpt}.

\item \code{pAcpt(object = Demuxmix) <- value}: Sets a new acceptance probability \code{pAcpt}.

\item \code{summary(Demuxmix)}: Summarizes the classification results and
estimates error rates.

}}
\section{Slots}{

\describe{
\item{\code{models}}{A list of mixture models. One model per HTO.}

\item{\code{outliers}}{A logical matrix of size HTOs x droplets identifying outlier 
values excluded from model fitting.}

\item{\code{clusterInit}}{A numeric matrix of size HTOs x droplets with the class
memberships used to initialize model fitting. A value of 1 corresponds to
the negative component and a value of 2 to the positive component.}

\item{\code{posteriorProb}}{A numeric matrix of size HTO x droplets with the
posterior probabilities that a droplet is positive for an HTO.}

\item{\code{tailException}}{A logical matrix of size HTO x droplets identifying
posterior probabilities that would be adjusted based on the exception
rules defined when calling \code{\link{demuxmix}} to correct inaccuracies
at the extreme tails of the mixture distributions. See
\code{\link{demuxmix}} for details.}

\item{\code{modelSelection}}{A \code{data.frame} with information about the model
selection process if parameter \code{model} was set to 'auto'. Empty 
\code{data.frame} if model was specified manually.}

\item{\code{parameters}}{A list with the \code{\link{demuxmix}} parameters
used to generate the model represented by this class.}
}}

\examples{
set.seed(2642)
simdata <- dmmSimulateHto(class=rbind(c(rep(TRUE, 220), rep(FALSE, 200)),
                                      c(rep(FALSE, 200), rep(TRUE, 220))))

dmm <- demuxmix(simdata$hto, rna=simdata$rna, pAcpt=0.9)
pAcpt(dmm)
dmm
head(dmmClassify(dmm))

}
\seealso{
\code{\link{dmmClassify}} to obtain classification results.
  \code{\link{plotDmmHistogram}}, \code{\link{plotDmmScatter}},
  \code{\link{plotDmmPosteriorP}}, and \code{\link{dmmOverlap}} to assess
  the model fit.
}
