% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{scores2colours}
\alias{scores2colours}
\title{Translate values into colours}
\usage{
scores2colours(
    x,
    range = c(min(0, min(x)), max(x)),
    n.colors = 10,
    palette = colorRampPalette(c("#3C5488FF", "white", "#F39B7FFF"))
)
}
\arguments{
\item{x}{numeric vector to be colorised}

\item{range}{range of values to filter \code{x} (values out of
the range will be collapsed to the closest limit)}

\item{n.colors}{integer, number of colors in the palette}

\item{palette}{palette function that generates a scale of
colours given the number of desired colours. Defaults to a
blue-white-red scale by \code{\link[grDevices:colorRamp]{colorRampPalette}}}
}
\value{
Character vector with hex colours
}
\description{
Create a vector of hex colours from numeric values,
typically diffusion scores
}
\examples{
set.seed(1)
scores2colours(runif(20))

}
