% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_fxns.R
\name{create_domino}
\alias{create_domino}
\title{Create a domino object and prepare it for network construction}
\usage{
create_domino(
  rl_map,
  features,
  counts = NULL,
  z_scores = NULL,
  clusters = NULL,
  use_clusters = TRUE,
  tf_targets = NULL,
  verbose = TRUE,
  use_complexes = TRUE,
  rec_min_thresh = 0.025,
  remove_rec_dropout = TRUE,
  tf_selection_method = "clusters",
  tf_variance_quantile = 0.5
)
}
\arguments{
\item{rl_map}{Data frame where each row describes a receptor-ligand interaction with required columns gene_A & gene_B including the gene names for the receptor and ligand and type_A & type_B annotating if genes A and B are a ligand (L) or receptor (R)}

\item{features}{Either a path to a csv containing cell level features of interest (ie. the auc matrix from pySCENIC) or named matrix with cells as columns and features as rows.}

\item{counts}{Counts matrix for the data. This is only used to threshold receptors on dropout.}

\item{z_scores}{Matrix containing z-scored expression data for all cells with cells as columns and features as rows.}

\item{clusters}{Named factor containing cell cluster with names as cells.}

\item{use_clusters}{Boolean indicating whether to use clusters.}

\item{tf_targets}{Optional. A list where names are transcription factors and the stored values are character vectors of genes in the transcription factor's regulon.}

\item{verbose}{Boolean indicating whether or not to print progress during computation.}

\item{use_complexes}{Boolean indicating whether you wish to use receptor/ligand complexes in the receptor ligand signaling database. If FALSE, receptor/ligand pairs where either functions as a protein complex will not be considered when constructing the signaling network.}

\item{rec_min_thresh}{Minimum expression level of receptors by cell. Default is 0.025 or 2.5 percent of all cells in the data set. This is important when calculating correlation to connect receptors to transcription activation. If this threshold is too low then correlation calculations will proceed with very few cells with non-zero expression.}

\item{remove_rec_dropout}{Whether to remove receptors with 0 expression counts when calculating correlations. This can reduce false positive correlation calculations when receptors have high dropout rates.}

\item{tf_selection_method}{Selection of which method to target transcription factors. If 'clusters' then differential expression for clusters will be calculated. If 'variable' then the most variable transcription factors will be selected. If 'all' then all transcription factors in the feature matrix will be used. Default is 'clusters'. Note that if you wish to use clusters for intercellular signaling downstream to MUST choose clusters.}

\item{tf_variance_quantile}{What proportion of variable features to take if using variance to threshold features. Default is 0.5. Higher numbers will keep more features. Ignored if tf_selection_method is not 'variable'}
}
\value{
A domino object
}
\description{
This function reads in a receptor ligand signaling database, cell level
features of some kind (ie. output from pySCENIC), z-scored single cell data,
and cluster id for single cell data, calculates a correlation matrix between
receptors and other features (this is transcription factor module scores if
using pySCENIC), and finds features enriched by cluster. It will return a
domino object prepared for \code{\link[=build_domino]{build_domino()}}, which will calculate a signaling
network.
}
\examples{
example(create_rl_map_cellphonedb, echo = FALSE)
example(create_regulon_list_scenic, echo = FALSE)
data(SCENIC)
data(PBMC)

pbmc_dom_tiny <- create_domino(
 rl_map = rl_map_tiny, features = SCENIC$auc_tiny,
 counts = PBMC$RNA_count_tiny, z_scores = PBMC$RNA_zscore_tiny,
 clusters = PBMC$clusters_tiny, tf_targets = regulon_list_tiny,
 use_clusters = TRUE, use_complexes = TRUE, remove_rec_dropout = FALSE,
 verbose = FALSE
 )

pbmc_dom_tiny_no_clusters <- create_domino(
 rl_map = rl_map_tiny, features = SCENIC$auc_tiny,
 counts = PBMC$RNA_count_tiny, z_scores =PBMC$RNA_zscore_tiny,
 clusters = PBMC$clusters_tiny, tf_targets = regulon_list_tiny,
 use_clusters = FALSE, use_complexes = FALSE,
 rec_min_thresh = 0.1, remove_rec_dropout = TRUE,
 tf_selection_method = "all",
 verbose = FALSE
 )

}
