% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fxns.R
\name{incoming_signaling_heatmap}
\alias{incoming_signaling_heatmap}
\title{Create a cluster incoming signaling heatmap}
\usage{
incoming_signaling_heatmap(
  dom,
  rec_clust,
  clusts = NULL,
  min_thresh = -Inf,
  max_thresh = Inf,
  scale = "none",
  normalize = "none",
  title = TRUE,
  ...
)
}
\arguments{
\item{dom}{Domino object with network built (\code{\link[=build_domino]{build_domino()}})}

\item{rec_clust}{Which cluster to select as the receptor. Must match naming of clusters in the domino object.}

\item{clusts}{Vector of clusters to be included. If NULL then all clusters are used.}

\item{min_thresh}{Minimum signaling threshold for plotting. Defaults to -Inf for no threshold.}

\item{max_thresh}{Maximum signaling threshold for plotting. Defaults to Inf for no threshold.}

\item{scale}{How to scale the values (after thresholding). Options are 'none', 'sqrt' for square root, or 'log' for log10.}

\item{normalize}{Options to normalize the matrix. Accepted inputs are 'none' for no normalization, 'rec_norm' to normalize to the maximum value with each receptor cluster, or 'lig_norm' to normalize to the maximum value within each ligand cluster}

\item{title}{Either a string to use as the title or a boolean describing whether to include a title. In order to pass the 'main' parameter to  \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}  you must set title to FALSE.}

\item{...}{Other parameters to pass to  \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}. Note that to use the 'column_title' parameter of  \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}  you must set title = FALSE}
}
\value{
a Heatmap rendered to the active graphics device
}
\description{
Creates a heatmap of a cluster incoming signaling matrix. Each cluster has a
list of ligands capable of activating its enriched transcription factors. The
function creates a heatmap of cluster average expression for all of those
ligands. A list of all cluster incoming signaling matrices can be found in
the cl_signaling_matrices slot of a domino option as an alternative to this
plotting function.
}
\examples{
example(build_domino, echo = FALSE)
#incoming signaling of the CD8  T cells
incoming_signaling_heatmap(pbmc_dom_built_tiny, "CD8_T_cell")

}
