% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateStats.R
\name{generateStats}
\alias{generateStats}
\title{generateStats Statistics function to summarize expression
data of an s.e. object.}
\usage{
generateStats(se, groupings= NULL, mode_mean=TRUE, LOG2=TRUE)
}
\arguments{
\item{se}{A SummarizedExperiment object.}

\item{groupings}{A grouping (annotation column), e.g. groupings="something".}

\item{mode_mean}{Boolean, Calculate RowMeans or RowMedians.}

\item{LOG2}{Boolean, Calculate LOG2.}
}
\value{
Returns an invisible list of summary statistics, kruskal test
and raw data of an s.e. object.
}
\description{
generateStats is a summary function used on various
expression data.
}
\details{
This function completes summary statistics of the expression
of the supplied s.e. object.
}
\examples{
data(hmel.se)
generateStats(se, groupings="annotation.ZA")
}
\references{
The "doseR" package, 2018 (in press).
}
\author{
AJ Vaestermark, JR Walters.
}
