% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DM.R
\name{se.DM}
\alias{se.DM}
\title{se.DM Function to convert SummarizedExperiment object to LME4 input.}
\usage{
se.DM(se, weightByLL = TRUE)
}
\arguments{
\item{se}{A SummarizedExperiment object containing FPKM values and at least
one annotation column.}

\item{weightByLL}{Logical, weigh by log likelihood score.}
}
\value{
Returns LME4 input.
}
\description{
This function generates LME4 input.
}
\details{
This function converts SummarizedExperiment object.
}
\examples{
data(hmel.se)
f_se <- quantFilter(se, lo.bound = 0.4, hi.bound = 0.5)
dm <- se.DM(f_se)
}
\references{
The "doseR" package, 2018 (in press).
}
\author{
AJ Vaestermark, JR Walters.
}
