% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{.computeConsensusFromSignature}
\alias{.computeConsensusFromSignature}
\title{Compute consensus concordant signatures from a single input signature}
\usage{
.computeConsensusFromSignature(
  signature,
  outputLib,
  filterThreshold = NULL,
  filterProp = NULL,
  similarityThreshold = 0.321,
  paired = TRUE,
  outputCellLines = NULL
)
}
\arguments{
\item{signature}{A data.frame / tibble / DataFrame produced by
\code{\link[=prepareSignature]{prepareSignature()}} or \code{\link[=getSignature]{getSignature()}} with standard signature columns.}

\item{outputLib}{Character. One of "OE", "KD", or "CP" indicating the
iLINCS library to search for concordant signatures.}

\item{filterThreshold}{Numeric (optional). Absolute threshold(s) passed to
\code{\link[=filterSignature]{filterSignature()}}. Use either \code{filterThreshold} or \code{filterProp}.}

\item{filterProp}{Numeric in (0, 0.5] (optional). Proportion for quantile
based filtering in \code{\link[=filterSignature]{filterSignature()}}. Ignored if \code{filterThreshold} is
supplied.}

\item{similarityThreshold}{Numeric in 0..1. Minimum absolute similarity
retained by \code{\link[=consensusConcordants]{consensusConcordants()}}.}

\item{paired}{Logical. If TRUE perform separate up / down filtering and
concordance queries; otherwise aggregate direction = "any".}

\item{outputCellLines}{Optional character vector restricting target cell
lines during consensus filtering. Passed to \code{\link[=consensusConcordants]{consensusConcordants()}}.}
}
\value{
A tibble of consensus concordant signatures with standardized target
columns (already renamed via internal consensus pipeline). Columns include
\code{TargetSignature}, \code{Target}, \code{TargetCellLine}, \code{Similarity}, \code{pValue},
\code{InputSigDirection}, \code{SignatureType}, and optional time / concentration.
}
\description{
This internal helper wraps the common paired / unpaired workflow used by
\code{investigateSignature()} and \code{investigateTarget()} for a single already
prepared or retrieved signature. It applies directional filtering, queries
iLINCS for concordant signatures, and collapses results via
\code{\link[=consensusConcordants]{consensusConcordants()}}.
}
\details{
Error handling is delegated to component functions:
\itemize{
\item Library validation via \code{\link[=stopIfInvalidLibraries]{stopIfInvalidLibraries()}}
\item Signature structure via \code{\link[=stopIfInvalidSignature]{stopIfInvalidSignature()}} (indirectly used by
\code{\link[=getConcordants]{getConcordants()}})
\item Filtering parameter validation via \code{\link[=.validateFilterSignatureInput]{.validateFilterSignatureInput()}}
\item Concordance / network errors via internal iLINCS response processors.
}

If both \code{filterThreshold} and \code{filterProp} are supplied an error is raised
upstream in \code{\link[=filterSignature]{filterSignature()}}. Provide only one.
}
\examples{
NULL
}
\keyword{internal}
