% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSignature.R
\name{.createSignatureRequest}
\alias{.createSignatureRequest}
\title{Create HTTP request for iLINCS signature retrieval}
\usage{
.createSignatureRequest(sigId)
}
\arguments{
\item{sigId}{A character string containing the iLINCS signature ID to retrieve.}
}
\value{
An httr2 request object configured for the iLINCS downloadSignature endpoint.
}
\description{
This internal function constructs and configures the HTTP request object
for retrieving signature data from the iLINCS API.
}
\details{
This function builds a complete HTTP request by:
\enumerate{
\item Setting the base URL using \code{.ilincsBaseUrl()}
\item Appending the API path: "ilincsR/downloadSignature"
\item Adding query parameters: sigID and noOfTopGenes (set to Inf for all genes)
\item Setting the HTTP method to POST
\item Adding a user agent string using \code{.returnUserAgent()}
}

The request is configured but not executed - it must be performed using
the request execution function.
}
\examples{
NULL
}
\keyword{internal}
