% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getConcordants.R
\name{.detectSignatureDirection}
\alias{.detectSignatureDirection}
\title{Detect signature direction from expression values}
\usage{
.detectSignatureDirection(signature)
}
\arguments{
\item{signature}{A data.frame-like object containing the signature data.
Must have a column named "Value_LogDiffExp" with log fold-change values.}
}
\value{
Character string indicating signature direction: "Up", "Down", or "Any".
}
\description{
This internal function analyzes the log fold-change values in a signature
to determine the overall direction of regulation.
}
\details{
The function examines the "Value_LogDiffExp" column to determine direction:
\itemize{
\item "Up": All expression values are greater than or equal to zero
\item "Down": All expression values are less than or equal to zero
\item "Any": Mixed positive and negative values
}

Note that zero values are considered "Up" direction. This direction
information is used by iLINCS for signature analysis and is included
in the output results.
}
\examples{
NULL
}
\keyword{internal}
