% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSignature.R
\name{.isValidSignatureId}
\alias{.isValidSignatureId}
\title{Check if a signature ID exists in the metadata tables}
\usage{
.isValidSignatureId(sigId)
}
\arguments{
\item{sigId}{A character string or vector containing the signature ID(s) to validate.}
}
\value{
A logical value or vector: TRUE if the signature exists, FALSE otherwise.
Returns a vector of the same length as the input when given a vector.
}
\description{
This internal function validates whether a signature ID exists in any of
the metadata tables (CP, KD, or OE).
}
\details{
This function searches all three metadata tables:
\itemize{
\item Chemical Perturbagen (CP) metadata
\item Knockdown (KD) metadata
\item Overexpression (OE) metadata
}

The function checks the "SourceSignature" column in each metadata table
for the provided signature ID(s).
}
\examples{
NULL
}
\keyword{internal}
