% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusConcordants.R
\name{.selectAndOrderResults}
\alias{.selectAndOrderResults}
\title{Select and order consensus results columns}
\usage{
.selectAndOrderResults(concordants)
}
\arguments{
\item{concordants}{A dataframe containing processed concordants data.}
}
\value{
A dataframe with selected and ordered columns for consensus output.
}
\description{
This internal function selects the relevant columns for consensus results
and orders them appropriately for output.
}
\details{
This function:
\enumerate{
\item Selects standard consensus output columns
\item Orders results by descending absolute similarity
\item Handles both CP/KD libraries (with concentration) and OE libraries (without)
}
}
\examples{
\dontrun{
testData <- data.frame(
    signatureid = "SIG1",
    compound = "A",
    cellline = "A375",
    similarity = 0.8,
    sig_direction = "Up",
    pValue = 0.01
)
selected <- .selectAndOrderResults(testData)
}
}
\keyword{internal}
