% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{.stopIfInvalidColNames}
\alias{.stopIfInvalidColNames}
\title{Validate signature column names}
\usage{
.stopIfInvalidColNames(signature)
}
\arguments{
\item{signature}{A data.frame-like object containing signature data.}
}
\value{
Invisible NULL. The function throws an error if validation fails.
}
\description{
This internal function checks if the signature data frame has the expected
column names in the correct order for iLINCS compatibility.
}
\details{
The function validates that the signature has exactly the following columns
in the specified order:
\enumerate{
\item \code{signatureID}: Signature identifier
\item \code{ID_geneid}: Gene ID
\item \code{Name_GeneSymbol}: Gene symbol
\item \code{Value_LogDiffExp}: Log fold-change expression value
\item \code{Significance_pvalue}: Statistical significance p-value
}
}
\examples{
NULL
}
\keyword{internal}
