% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusConcordants.R
\name{.validateConsensusConcordantsInput}
\alias{.validateConsensusConcordantsInput}
\title{Validate consensusConcordants input parameters}
\usage{
.validateConsensusConcordantsInput(dots, paired, cutoff, cellLine)
}
\arguments{
\item{dots}{A list of dataframes passed via ... parameter.}

\item{paired}{Logical indicating whether paired analysis is requested.}

\item{cutoff}{Numeric similarity cutoff value.}

\item{cellLine}{Character vector of cell lines, or NULL.}
}
\value{
Invisible NULL. The function throws an error if validation fails.
}
\description{
This internal function validates all input parameters for the consensusConcordants
function to ensure they meet the required constraints.
}
\details{
This function performs the following validations:
\enumerate{
\item Ensures paired analysis has exactly two dataframes
\item Ensures unpaired analysis has exactly one dataframe
\item Validates cutoff is numeric and within reasonable range
\item Validates cellLine parameter format
}
}
\examples{
\dontrun{
# Valid calls (no errors)
testData <- data.frame(similarity = c(0.5, -0.3), compound = c("A", "B"))
.validateConsensusConcordantsInput(list(testData), FALSE, 0.3, NULL)
.validateConsensusConcordantsInput(list(testData, testData), TRUE, 0.3, "A375")

# Invalid calls (will throw errors)
.validateConsensusConcordantsInput(list(), FALSE, 0.3, NULL) # No data
.validateConsensusConcordantsInput(list(testData), TRUE, 0.3, NULL) # Paired needs 2 dataframes
}
}
\keyword{internal}
