% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterSignature.R
\name{.validateFilterSignatureInput}
\alias{.validateFilterSignatureInput}
\title{Validate filterSignature input parameters}
\usage{
.validateFilterSignatureInput(signature, direction, threshold, prop)
}
\arguments{
\item{signature}{A data.frame-like object (data.frame, tibble, or DataFrame)
containing the L1000 signature data.}

\item{direction}{Character string specifying the filtering direction.
Must be one of "up", "down", or "any".}

\item{threshold}{Numeric value or vector specifying absolute threshold(s).
Can be NULL, a single value, or a vector of two values. Cannot be specified
together with \code{prop}.}

\item{prop}{Numeric value specifying the proportion for quantile-based filtering.
Must be between 0 and 1. Cannot be specified together with \code{threshold}.}
}
\value{
Invisible NULL. The function throws an error if validation fails.
}
\description{
This internal function validates all input parameters for the filterSignature
function to ensure they meet the required constraints and are mutually compatible.
}
\details{
This function performs the following validations in order:
\enumerate{
\item Ensures \code{signature} is a data.frame-like object
\item Validates \code{direction} is one of the allowed values
\item Verifies that only one of \code{threshold} or \code{prop} is specified
\item For \code{threshold}: checks length (1-2 values) and order (lower, higher)
\item For \code{prop}: checks it's a single value between 0 and 1
}
}
\examples{
\dontrun{
# Valid calls (no errors)
sig <- data.frame(Value_LogDiffExp = c(-2, -1, 0, 1, 2))
.validateFilterSignatureInput(sig, "any", 1.0, NULL)
.validateFilterSignatureInput(sig, "up", NULL, 0.1)
.validateFilterSignatureInput(sig, "down", c(-1.5, 1.0), NULL)

# Invalid calls (will throw errors)
.validateFilterSignatureInput(sig, "invalid", 1.0, NULL) # Invalid direction
.validateFilterSignatureInput(sig, "any", 1.0, 0.1) # Both threshold and prop
.validateFilterSignatureInput(sig, "any", NULL, NULL) # Neither threshold nor prop
.validateFilterSignatureInput(sig, "any", c(1, 2, 3), NULL) # Too many thresholds
.validateFilterSignatureInput(sig, "any", c(2, 1), NULL) # Wrong threshold order
.validateFilterSignatureInput(sig, "any", NULL, 1.5) # Proportion > 1
.validateFilterSignatureInput(sig, "any", NULL, -0.1) # Proportion < 0
}
}
\keyword{internal}
