% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyRNASeq-normalize.R
\name{easyRNASeq correction methods}
\alias{easyRNASeq correction methods}
\alias{RPKM}
\alias{RPKM,RNAseq,ANY,ANY,ANY-method}
\alias{RPKM,matrix,ANY,vector,vector-method}
\alias{RPKM,RNAseq-method}
\title{easyRNASeq count table correction to RPKM}
\usage{
\S4method{RPKM}{matrix,ANY,vector,vector}(
  obj,
  from = c("exons", "features", "transcripts", "bestExons", "geneModels", "islands"),
  lib.size = numeric(1),
  feature.size = integer(1),
  simplify = TRUE,
  ...
)
}
\arguments{
\item{obj}{An object of class \code{\linkS4class{RNAseq}} or a
\code{matrix}, see details}

\item{from}{Determine the kind of coverage to use, choice limited to:
exons, features, transcripts, bestExons, geneModels or islands.}

\item{lib.size}{Precise the library size. It should be a named numeric
list, i.e. named after the sample names.}

\item{feature.size}{Precise the feature (e.g. exons, genes) sizes. It
should be a named numeric list, named after the feature names.}

\item{simplify}{If set to TRUE, whenever a feature (exon, feature, ...) is
duplicated in the count table, it is only returned once.}

\item{...}{additional arguments. See details}
}
\value{
A \code{matrix} containing RPKM corrected read counts.
}
\description{
Convert a count table obtained from the easyRNASeq function into an RPKM
corrected count table.
}
\details{
RPKM accepts two sets of arguments:
\itemize{
\item{RNAseq,character}{ the
\dots{} are additional arguments to be passed to the
\code{\link[easyRNASeq:easyRNASeq-accessors]{readCounts}} method.}
\item{matrix,named vector}{normalize a count matrix by providing the feature
sizes (e.g. gene sizes) as a named vector where the names match the row
names of the count matrix and the lib sizes as a named vector where the
names match the column names of the count matrix.}}
}
\examples{


	\dontrun{
	## get an RNAseq object
	rnaSeq <- easyRNASeq(filesDirectory=
		    			system.file(
					"extdata",
					package="RnaSeqTutorial"),
					pattern="[A,C,T,G]{6}\\\\.bam$",
				format="bam",
				readLength=36L,
				organism="Dmelanogaster",
				chr.sizes=as.list(seqlengths(Dmelanogaster)),
				annotationMethod="rda",
				annotationFile=system.file(
				                            "data",
							    "gAnnot.rda",
							    package="RnaSeqTutorial"),
				count="exons",
				outputFormat="RNAseq")

	## get the RPKM
	rpkm <- RPKM(rnaSeq,from="exons")
	
	## the same from a count table
	count.table <- readCounts(rnaSeq,count="exons")

	## get the RPKM
	## verify that the feature are sorted as the count.table
	all(.getName(rnaSeq,"exon") == rownames(count.table))
	feature.size <- unlist(width(ranges(rnaSeq)))

	## verify that the samples are ordered in the same way
	all(names(librarySize(rnaSeq)) == colnames(count.table))

	## get the RPKM
	rpkm <- RPKM(count.table,
			feature.size=feature.size,
			lib.size=librarySize(rnaSeq))
}

}
\seealso{
\code{\link[easyRNASeq:easyRNASeq-accessors]{readCounts}}
}
\author{
Nicolas Delhomme
}
\keyword{methods}
