% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getENCODEdata.R
\name{getENCODEdata}
\alias{getENCODEdata}
\title{Download enhancer sequences from ENCODE}
\usage{
getENCODEdata(
  genome,
  markers = "H3K4me1",
  window_size = 1000L,
  step = 50L,
  output = c("Enhancer", "raw_peaks"),
  ...
)
}
\arguments{
\item{genome}{An object of \link[BSgenome:BSgenome-class]{BSgenome}.}

\item{markers}{Enhancer markers. Default 'H3K4me1'. For active enhancer,
it can be set as c('H3K4me1', 'H3K27ac').
If markers is a `GRanges` object, the function will skip the download step.}

\item{window_size, step}{The size of windows and steps to split the peaks
into small pieces. These parameter is used because the width of
histone marker peaks are different sizes. Break the peaks into small
pieces can increase the matching score and align the matching for
different peaks into same size. The window_size is also be used for
overlapping detection of multiple histone markers.}

\item{output}{Output format. If it is 'raw_peaks', the raw peaks list will
be returned. Otherwise, the Enhancer object will be returned.}

\item{\dots}{Parameters can be passed to \link{queryEncode}}
}
\value{
An object of \link{Enhancers} with genome, and peaks.
The peaks is an object of GRanges. The genome is an object of BSgenome.
}
\description{
Query enhancer peak and extract sequences from ENCODE
}
\examples{
library(BSgenome.Hsapiens.UCSC.hg38)
hs <- getENCODEdata(genome=Hsapiens,
                    partialMatch=c(biosample_summary="spinal cord"))
}
