% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ssplot.R
\name{ssplot}
\alias{ssplot}
\alias{ssplot,enrichResult-method}
\alias{ssplot,gseaResult-method}
\alias{ssplot,compareClusterResult-method}
\alias{ssplot.enrichResult}
\alias{ssplot.compareClusterResult}
\title{ssplot}
\usage{
ssplot(x, ...)

\S4method{ssplot}{enrichResult}(x, showCategory = 30, ...)

\S4method{ssplot}{gseaResult}(x, showCategory = 30, ...)

\S4method{ssplot}{compareClusterResult}(x, showCategory = 30, ...)

ssplot.enrichResult(
  x,
  showCategory = 30,
  drfun = NULL,
  dr.params = list(),
  node_label = "group",
  ...
)

ssplot.compareClusterResult(
  x,
  showCategory = 30,
  pie = "equal",
  drfun = NULL,
  dr.params = list(),
  node_label = "group",
  ...
)
}
\arguments{
\item{x}{Enrichment result.}

\item{...}{additional parameters

additional parameters can refer the following parameters.
    \itemize{
      \item \code{layout} igraph layout function for node positioning
      \item \code{color} Variable that used to color enriched terms, e.g. 'pvalue','p.adjust' or 'qvalue'.
      \item \code{size_category} relative size of the categories
      \item \code{min_edge} The minimum similarity threshold for whether
        two nodes are connected, should between 0 and 1, default value is 0.2.
      \item \code{color_edge} color of the network edge
      \item \code{size_edge} relative size of edge width.
      \item \code{node_label} Select which labels to be displayed,
        one of 'category', 'group', 'all' and 'none'.
      \item \code{node_label_size} size of node label, default is 5.
      \item \code{pie} one of 'equal' or 'Count' to set the slice ratio of the pies (for `compareClusterResult` only).
      \item \code{label_format} a numeric value sets wrap length, alternatively a custom function to format axis labels.
      \item \code{clusterFunction} function of Clustering method, such as stats::kmeans(the default),
        cluster::clara, cluster::fanny or cluster::pam.
      \item \code{nWords} Numeric, the number of words in the cluster tags, the default value is 4.
      \item \code{nCluster} Numeric, the number of clusters,
        the default value is square root of the number of nodes.
    }

additional parameters can refer the emapplot function: \link{emapplot}.}

\item{showCategory}{A number or a vector of terms. If it is a number,
the first n terms will be displayed. If it is a vector of terms,
the selected terms will be displayed.}

\item{drfun}{The function used for dimension reduction,
e.g. `stats::cmdscale` (the default), `vegan::metaMDS`, or `ape::pcoa`.}

\item{dr.params}{list, the parameters of `tidydr::dr`.}

\item{node_label}{Select which labels to be displayed,
one of 'category', 'group', 'all' and 'none'.}

\item{pie}{one of 'equal' or 'Count' to set the slice ratio of the pies}
}
\value{
ggplot object
}
\description{
Similarity Space Plot for enrichment analysis
}
\details{
Creates 2D visualization of enrichment results using dimension reduction
techniques to show relationships between terms based on similarity.
}
\examples{
\dontrun{
    library(clusterProfiler)
    library(org.Hs.eg.db)
    library(enrichplot)
    library(GOSemSim)
    library(DOSE)
    data(geneList)
    gene <- names(geneList)[abs(geneList) > 2]
    ego <- enrichGO(gene  = gene,
        universe      = names(geneList),
        OrgDb         = org.Hs.eg.db,
        ont           = "BP",
        pAdjustMethod = "BH",
        pvalueCutoff  = 0.01,
        qvalueCutoff  = 0.05,
        readable      = TRUE)
    d <- godata('org.Hs.eg.db', ont="BP")
    ego2 <- pairwise_termsim(ego, method = "Wang", semData = d)
    ssplot(ego2)
}
}
\author{
Guangchuang Yu
}
