% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/volplot.R
\name{volplot}
\alias{volplot}
\alias{volplot,enrichResult-method}
\alias{volplot.enrichResult}
\title{volplot}
\usage{
volplot(
  x,
  color = "zScore",
  xintercept = 1,
  yintercept = 2,
  showCategory = 5,
  label_format = 30,
  ...
)

\S4method{volplot}{enrichResult}(
  x,
  color = "zScore",
  xintercept = 1,
  yintercept = 2,
  showCategory = 5,
  label_format = 30,
  ...
)

volplot.enrichResult(
  x,
  color = "zScore",
  xintercept = 1,
  yintercept = 2,
  showCategory = 5,
  label_format = 30,
  font.size = 12,
  size = 5
)
}
\arguments{
\item{x}{enrichment result.}

\item{color}{selected variable to color the dots}

\item{xintercept}{value to set x intercept}

\item{yintercept}{value to set y intercept}

\item{showCategory}{number of most significant enriched terms or selected terms to
display determined by the variable selected to color the dots}

\item{label_format}{a numeric value sets wrap length, alternatively a
custom function to format axis labels.}

\item{...}{Additional parameters}

\item{font.size}{font size for `theme_dose()`}

\item{size}{font size to label selected categories specified by showCategory}
}
\value{
ggplot object
}
\description{
volcano plot for enrichment result
}
\examples{
library(DOSE)
data(geneList)
de <- names(geneList)[1:100]
x <- enrichDO(de)
volplot(x)
}
\author{
Guangchuang Yu
}
