% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateSeq.R
\name{annotateSeq}
\alias{annotateSeq}
\title{annotateSeq}
\usage{
annotateSeq(
  peak,
  tssRegion = c(-3000, 3000),
  TxDb = NULL,
  level = "transcript",
  assignGenomicAnnotation = TRUE,
  genomicAnnotationPriority = c("Promoter", "5UTR", "3UTR", "Exon", "Intron",
    "Downstream", "Intergenic"),
  annoDb = NULL,
  addFlankGeneInfo = FALSE,
  flankDistance = 5000,
  sameStrand = FALSE,
  ignoreOverlap = FALSE,
  ignoreUpstream = FALSE,
  ignoreDownstream = FALSE,
  overlap = "TSS",
  verbose = TRUE,
  columns = c("ENTREZID", "ENSEMBL", "SYMBOL", "GENENAME")
)
}
\arguments{
\item{peak}{peak file or GRanges object}

\item{tssRegion}{Region Range of TSS}

\item{TxDb}{TxDb or EnsDb annotation object}

\item{level}{one of transcript and gene}

\item{assignGenomicAnnotation}{logical, assign peak genomic annotation or not}

\item{genomicAnnotationPriority}{genomic annotation priority}

\item{annoDb}{annotation package}

\item{addFlankGeneInfo}{logical, add flanking gene information from the peaks}

\item{flankDistance}{distance of flanking sequence}

\item{sameStrand}{logical, whether find nearest/overlap gene in the same strand}

\item{ignoreOverlap}{logical, whether ignore overlap of TSS with peak}

\item{ignoreUpstream}{logical, if True only annotate gene at the 3' of the peak.}

\item{ignoreDownstream}{logical, if True only annotate gene at the 5' of the peak.}

\item{overlap}{one of 'TSS' or 'all', if overlap="all", then gene overlap with peak will be reported as nearest gene, no matter the overlap is at TSS region or not.}

\item{verbose}{print message or not}

\item{columns}{names of columns to be obtained from database}
}
\value{
data.frame or GRanges object with columns of:

all columns provided by input.

annotation: genomic feature of the peak, for instance if the peak is
located in 5'UTR, it will annotated by 5'UTR. Possible annotation is
Promoter-TSS, Exon, 5' UTR, 3' UTR, Intron, and Intergenic.

geneChr: Chromosome of the nearest gene

geneStart: gene start

geneEnd: gene end

geneLength: gene length

geneStrand: gene strand

geneId: entrezgene ID

distanceToTSS: distance from peak to gene TSS

if annoDb is provided, extra column will be included:

ENSEMBL: ensembl ID of the nearest gene

SYMBOL: gene symbol

GENENAME: full gene name
}
\description{
Annotate peaks
}
\examples{
data(peakAnno)
peakAnno
}
\seealso{
[plotAnnoBar()] [plotAnnoPie()] [plotDistToTSS()]
}
\author{
G Yu
}
