% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagMatrix.R
\name{getBioRegion}
\alias{getBioRegion}
\title{Prepare a bioregion of selected feature}
\usage{
getBioRegion(
  TxDb = NULL,
  upstream = 1000,
  downstream = 1000,
  by = "gene",
  type = "start_site"
)
}
\arguments{
\item{TxDb}{TxDb object or self-made granges object.}

\item{upstream}{upstream extension. One of actual number or rel() object.}

\item{downstream}{downstream extension. One of actual number or rel() object.}

\item{by}{one of 'gene', 'transcript', 'exon', 'intron' , '3UTR' , '5UTR', 'UTR'.}

\item{type}{one of "start_site", "end_site", "body".}
}
\value{
GRanges object
}
\description{
Prepare a bioregion of selected feature
}
\details{
this function combined previous functions getPromoters(), getBioRegion() and getGeneBody() 
in order to solve the following issues.

(1) <https://github.com/GuangchuangYu/ChIPseeker/issues/16>

(2) <https://github.com/GuangchuangYu/ChIPseeker/issues/87>

1. function can provide a region of interest from txdb object. 
2. function can make region from granges object. txdb object do not contain insulator or enhancer regions. 
Users can provide these regions through self-made granges object \url{https://github.com/YuLab-SMU/ChIPseeker/issues/189}.

There are three kinds of way to extend regions: start_site, end_site and body. 
We take transcript region to expain the differences of these three regions (tx: chr1 1000 1400). 

(1) body region refers to the 1000 ~ 1400 bp.

(2) start_site region with (upstream = upstream = 100) refers to 900-1100bp. 

(3) end_site region with (upstream = upstream = 100) refers to 1300-1500bp.
}
\examples{
require(TxDb.Hsapiens.UCSC.hg38.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg38.knownGene
getBioRegion(txdb)
}
\author{
Guangchuang Yu
}
