% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiSeeker-package.R
\docType{data}
\name{peakAnno}
\alias{peakAnno}
\title{Example data of peak annotation}
\format{
A `csAnno` object containing 220 annotated peaks.
}
\value{
csAnno object
}
\description{
A `csAnno` object representing the annotation result of the example peak set `demo_peak`.  
Peaks were annotated using the function `annotateSeq()` in `epiSeeker`.
}
\section{Provenance}{

Input peaks were taken from the example dataset `demo_peak`.
Annotation was generated using `epiSeeker::annotateSeq()`.
}

\section{Data structure}{

A `csAnno` S4 object with the following slots:
\describe{
  \item{`anno`}{A `GRanges` object containing the annotated peaks,
         including peak coordinates, basic peak metrics, and gene-based annotation fields.}
  \item{`tssRegion`}{Numeric vector of length two defining the upstream
         and downstream window used for TSS annotation.}
  \item{`level`}{Character string indicating whether annotation was
         performed at the `"transcript"` or `"gene"` level.}
  \item{`hasGenomicAnnotation`}{Logical value indicating whether
         detailed genomic annotation (promoter, exon, intron, etc.) was computed.}
  \item{`detailGenomicAnnotation`}{A data frame providing per-peak
         binary indicators for genomic categories.}
  \item{`annoStat`}{A data frame summarizing annotation category
         frequencies across the annotated peak set.}
  \item{`peakNum`}{Total number of annotated peaks.}
}
}

